///////////////////////////////////////////////////////////
//                   ExtraFunctionsFcl                   //
//              //
//                     LCL.                 //
//              Copyright (C) 2007-2010 Sagrer           //
//                                                       //
//                             //
//                  Modified LGPL v2.1                   //
//           .  COPYING.modifiedLGPL.txt           //
//                                                       //
//                    0.3                    //
//                                                       //
//                  sagrer@yandex.ru                     //
///////////////////////////////////////////////////////////

//      , ....  :
// 1)  (Sagrer)  (sagrer@yandex.ru)

////////////////////////////////////////////////////////////////////////

unit ExtraFunctionsLcl;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Windows, Registry, crc;
  
const
  DoDebugOutput = true;            //   .

  // ...
  
  //EnvPathAdd
  EnvPathAdd_User = 0;
  EnvPathAdd_Global = 1;
  
type
  TListOfStringLists = class        //     %).
  private
    // 
    StringLists : array of TStringList;
  protected
  public
    //-...
    constructor Create; virtual;
    destructor Destroy; override;

    // ...
    procedure SetCount(const NewCount : Integer);   //   ,   ,   -  .
    function AddList : Integer;       //    ,   .
    function InsertList(const Index : Integer) : Integer;   //    .       .
    procedure RemoveList(const Index : Integer);   //    .
    function Count : Integer;      //  .
    function GetList(const Index : Integer) : TStringList;   //    .
  end;

// .
Function StrRPos(str1,str2 : pchar) : pchar;  //    FPC.    str2  str1,    .
Function Parse( var S : AnsiString; const Separators : AnsiString ) : AnsiString;   //   ,      KOL.
Function ParseTail( var S : AnsiString; const Separators : AnsiString ) : AnsiString;   //   ,    .
Function ParseNumericHead(var S : AnsiString) : AnsiString;    //       -.
Function IsNumericStr (Str : string) : boolean;      //    ,      .
Function IsVersionStr (Str : string) : boolean;      //    .
Function IsNewVersion(OldVer, NewVer : string) : boolean;     //  ,   .
Procedure ParsePathString(const PathString : string; var PathStringList : TStringList);  //        TStringList.
Function CombinePathString(const PathStringList : TStringList) : string;  //  TStringList   Path.
Function EnvPathExists(const PathStr : string; const CheckUser, CheckGlobal : boolean) : boolean;   //,    path   .
Function EnvPathRemove(const PathStr : string; const CheckUser, CheckGlobal : boolean) : boolean;   //     PATH.  - true  -  .
Function EnvPathAdd(const PathStr : string; const Target : integer; const ForceRemoveDoubles : boolean = true; const ForceCreateLocal : boolean = false) : boolean;     //    PATH.
Function TrimExLeft(const InputStr, TrimChars : string) : string;   //  .
Function TrimExRight(const InputStr, TrimChars : string) : string;   //  .
Function TrimEx(const InputStr, TrimChars : string) : string;   //    .
Function FileToCRC32(const FileName : string; const ConsoleOutput : boolean = false) : cardinal;   // CRC32  ,       .
Function CheckCharNum(const Ch : char) : boolean;    // -    
Function CheckStrInt(const St : string) : boolean;    // -      
Function CheckStrFloat(const St : string) : boolean;   // -      
Function IntToBool(const InputInt : Integer) : boolean;   // Integer  Boolean
Function StrToBool(const InputStr : AnsiString) : boolean;  // String  Boolean
Function BoolToInt(const InputBool : boolean) : Integer;  // Boolean  Integer
Function BoolToStr(const InputBool : boolean) : AnsiString;   // Boolean  String
Function ReadFirstLineFromStr(const InputStr : AnsiString) : AnsiString;  //       #13  #10  #13  .

implementation

uses
  ExtraFileUtilsLCL;
  
/////////////////////////////////////////////
//            TListOfStringLists           //
/////////////////////////////////////////////

//     %).

//-----------------------------------------//
//        -...      //
//-----------------------------------------//

constructor TListOfStringLists.Create;
begin
  //  ,     .
  SetLength(Self.StringLists,0);
end;

destructor TListOfStringLists.Destroy;
var
  I : Integer;
begin
  // 
  for I := 0 to Length(Self.StringLists)-1 do begin
    // ,     .
    Self.StringLists[i].Free;
  end;
  //      .
  SetLength(Self.StringLists,0);

  //  
  inherited;
end;

//------------------------------------------//
//             ...            //
//------------------------------------------//

procedure TListOfStringLists.SetCount(const NewCount : Integer);
//   ,   ,   -  .
var
  I, J : Integer;
begin
  //   -     -   ,  .
  if NewCount < Length(Self.StringLists) then begin
    //  .   .
    for I := NewCount to Length(Self.StringLists)-1 do begin
      // ,     .
      Self.StringLists[I].Free;
    end;
    //    .
    SetLength(Self.StringLists,NewCount);
  end
  else if NewCount > Length(Self.StringLists) then begin
    //  .    .
    J := Length(Self.StringLists);
    SetLength(Self.StringLists,NewCount);
    //   .
    for I := J to NewCount-1 do begin
      Self.StringLists[I] := TStringList.Create;
    end;
  end;
  
  //  ,       Length = GetLength(Self.StringLists).
  //            .
end;

function TListOfStringLists.AddList : Integer;
//    ,   .
begin
  //    1 .
  Result := Length(Self.StringLists);      //    .
  SetLength(Self.StringLists,Result+1);
  // .
  Self.StringLists[Result] := TStringList.Create;
end;

function TListOfStringLists.InsertList(const Index : Integer) : Integer;
//    .       .
var
  TempPointer : TStringList;
  I : Integer;
  
begin
  //+1  ...
  Result := Self.AddList;
  //,  Index ,     -      .
  if Index < Result then begin
    //   ...
    TempPointer := Self.StringLists[Result];
    //       Index "" ...
    for I := Result downto Index+1 do begin
      Self.StringLists[I] := Self.StringLists[I-1];
    end;
    //    "" ...
    Self.StringLists[Index] := TempPointer;
  end;
end;

procedure TListOfStringLists.RemoveList(const Index : Integer);
//    .
var
  I : Integer;
begin
  //  .   ,      .
  if Length(Self.StringLists) > Index then begin
    //  Index-   - .
    Self.StringLists[Index].Free;
    //  -  ...
    if Length(Self.StringLists)-1 > Index then begin
      for I := Index to Length(Self.StringLists)-2 do begin
        Self.StringLists[I] := Self.StringLists[I+1];
      end;
    end;
    //   .
    SetLength(Self.StringLists,Length(Self.StringLists)-1);
  end;
end;

function TListOfStringLists.Count : Integer;
//  .
begin
  Result := Length(Self.StringLists);    //  .
end;

function TListOfStringLists.GetList(const Index : Integer) : TStringList;
//    .
begin
  Result := Self.StringLists[Index];
end;
  
/////////////////////////////////////////////
//                        //
/////////////////////////////////////////////

Function StrRPos(str1,str2 : pchar) : pchar;
//    FPC.
//   str2  str1,    .
var
   p : pchar;
   lstr2 : SizeInt;
begin
   StrRPos:=nil;
   if (str1 = nil) or (str2 = nil) then
     exit;
   p:=strrscan(str1,str2^);
   if p=nil then
     exit;
   lstr2:=strlen(str2);
   while p<>nil do
     begin
        if strlcomp(p,str2,lstr2)=0 then
          begin
             StrRPos:=p;
             exit;
          end;
        dec(p);
        p:=strrscan(p,str2^);
     end;
end;

Function Parse( var S : AnsiString; const Separators : AnsiString ) : AnsiString;
//   ,      KOL.
var Pos : Integer;

begin
  Pos := Longint( StrPos( PChar(S), PChar(Separators) ) - PChar(S) + 1 ) ;
  if Pos <= 0 then
     Pos := Length( S ) + Length(Separators);
  Result := S;
  S := Copy( Result, Pos + Length(Separators), MaxInt );
  Result := Copy( Result, 1, Pos - 1 );
end;

Function ParseTail( var S : AnsiString; const Separators : AnsiString ) : AnsiString;
//   ,    .
var Pos : Integer;

begin
  Pos := Longint( StrRPos( PChar(S), PChar(Separators) ) - PChar(S) + 1 ) ;
  Result := S;
  S := Copy(Result, 1, Pos-1);
  Result := Copy(Result, Pos+Length(Separators), Length(Result)-(Pos+Length(Separators))+1);
end;

Function ParseNumericHead(var S : AnsiString) : AnsiString;
//       -.
var
  Pos : Integer;
  Finded : Boolean;

begin
  //.
  Pos := 0;
  Finded := false;
  
  //  "-"
  repeat
    Pos := Pos+1;
    if Pos <= Length(S) then begin
      if IsNumericStr(S[Pos]) = false then begin
        //.
        Finded := true;
        Pos := Pos-1;
      end;
    end;
  until (Pos = Length(S)) or (Finded = true);
  
  // ,  .
  Result := Copy(S,1,Pos);
  Delete(S,1,Pos);
end;

Function IsNumericStr (Str : string) : boolean;
var
  I, StrLength : integer;
  FindedChar : boolean;
begin
  //    ,      .

  Result := true;  // .

  StrLength := Length(Str);
  If StrLength > 0 then begin
    //       .
    For I := 1 to StrLength do begin
      FindedChar := true;
      If Str[I] = '1' then FindedChar := false;  //  1  -      :)
      If Str[I] = '2' then FindedChar := false;
      If Str[I] = '3' then FindedChar := false;
      If Str[I] = '4' then FindedChar := false;
      If Str[I] = '5' then FindedChar := false;
      If Str[I] = '6' then FindedChar := false;
      If Str[I] = '7' then FindedChar := false;
      If Str[I] = '8' then FindedChar := false;
      If Str[I] = '9' then FindedChar := false;
      If Str[I] = '0' then FindedChar := false;

      //    -  -   .
      If FindedChar = true then Result := false;
    end;
  end
  else begin
    Result := false;  //  .
  end;
end;

Function IsVersionStr (Str : string) : boolean;
var
  I, StrLength : integer;
  FindedChar, WasPoint : boolean;
begin
  //    .

  Result := true;  // .

  StrLength := Length(Str);
  If StrLength > 0 then begin
    //       .
    WasPoint := false;
    For I := 1 to StrLength do begin
      FindedChar := true;
      If Str[I] = '1' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '2' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '3' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '4' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '5' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '6' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '7' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '8' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '9' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '0' then begin
        FindedChar := false;
        WasPoint := false;
      end;
      If Str[I] = '.' then begin
        FindedChar := false;
        If WasPoint = true then begin
          //      -  .
          FindedChar := true;
        end;
        WasPoint := true;
      end;

      //    -     -   .
      If FindedChar = true then Result := false;
    end;
  end
  else begin
    Result := false;  //  .
  end;
end;

Function IsNewVersion(OldVer, NewVer : string) : boolean;
var
  CurrVerLevels, I,
  OldVerLevels, MaxLevel : integer;
  TempStr, TempStr2,
  OldVerTemp, NewVerTemp : string;
begin
  //  ,   .

  Result := false;  //  .
  OldVerTemp := OldVer;
  NewVerTemp := NewVer;


  If (IsVersionStr(OldVer) = true) and (IsVersionStr(NewVer) = true) then begin
    //     - .

    //  -       .
    TempStr := NewVerTemp;
    TempStr2 := '';      //        Parse  .
    CurrVerLevels := 1;  //   1 .
    repeat
      If Pos('.',TempStr) <> 0 then begin
        CurrVerLevels := CurrVerLevels + 1;   //   1 .
        TempStr2 := Parse(TempStr,'.');
      end;
    until Pos('.',TempStr) = 0;

    //  .
    TempStr := OldVerTemp;
    OldVerLevels := 1;  //   1 .
    repeat
      If Pos('.',TempStr) <> 0 then begin
        OldVerLevels := OldVerLevels + 1;   //   1 .
        TempStr2 := Parse(TempStr,'.');
      end;
    until Pos('.',TempStr) = 0;

    //   .
    If CurrVerLevels > OldVerLevels then begin
      MaxLevel := CurrVerLevels;
    end
    else begin
      MaxLevel := OldVerLevels;
    end;

    // -       -  .
    If CurrVerLevels < MaxLevel then begin
      For I := 1 to MaxLevel - CurrVerLevels do begin
        NewVerTemp := NewVerTemp+'.0';
      end;
    end;
    If OldVerLevels < MaxLevel then begin
      For I := 1 to MaxLevel - OldVerLevels do begin
        OldVerTemp := OldVerTemp+'.0';
      end;
    end;

    //   -   .
    I := 0;
    repeat
      I := I+1;
      TempStr := Parse(OldVerTemp,'.');
      TempStr2 := Parse(NewVerTemp,'.');
      If StrToInt(TempStr2) > StrToInt(TempStr) then Result := true;
    until (I = MaxLevel) or (Result = true);
  end;
end;



Procedure ParsePathString(const PathString : string; var PathStringList : TStringList);
//        TStringList.
begin

  // .
  PathStringList.Clear;
  
  //...
  ExtractStrings([';'], [' '], PChar(PathString), PathStringList);
end;

Function CombinePathString(const PathStringList : TStringList) : string;
//  TStringList   Path.
var
  I : integer;
begin

  Result := '';
  
  if PathStringList.Count > 0 then begin
    for I := 0 to PathStringList.Count-1 do begin
      // ...
      Result := Result+PathStringList.Strings[I];
      //   - .
      if I < PathStringList.Count-1 then begin
        Result := Result+';';
      end;
    end;
  end;
  
end;

Function EnvPathExists(const PathStr : string; const CheckUser, CheckGlobal : boolean) : boolean;
//,    path   .
var
  Registr : TRegistry;
  PathVar : string;
  PathVarList : TStringList;
  I : Integer;

  Function SearcherCode : boolean;
  begin
    Result := false;

    // ...
    PathVar := Registr.ReadString('PATH');
    // ...
    ParsePathString(PathVar,PathVarList);
    if PathVarList.Count > 0 then begin
      //    .      .
      I := -1;
      repeat
        I := I+1;
        if UpperCase(DelLastSlash(PathVarList.Strings[I])) = UpperCase(DelLastSlash(PathStr)) then begin
          Result := true;   //  % ).
        end;
      until (I >= PathVarList.Count-1) or (Result = true);
    end;
  end;

begin

  //..
  Registr := TRegistry.Create;
  PathVarList := TStringList.Create;
  Result := false;

  //
  //...
  If CheckUser = true then begin
    Registr.RootKey := HKEY_CURRENT_USER;
    Registr.OpenKey('\Environment',false);
    Result := SearcherCode();
  end;

  //...
  If CheckGlobal = true then begin
    Registr.RootKey := HKEY_LOCAL_MACHINE;
    Registr.OpenKey('\SYSTEM\CurrentControlSet\Control\Session Manager\Environment',false);
    Result := Result or SearcherCode();
  end;

  // ...
  Registr.Free;
  PathVarList.Free;

end;

Function EnvPathRemove(const PathStr : string; const CheckUser, CheckGlobal : boolean) : boolean;
//     PATH.  - true  -  .
var
  Registr : TRegistry;
  PathVar : string;
  PathVarList : TStringList;
  I : Integer;
  Finded : boolean;
  
  Function RemoverCode : boolean;
  begin
    Result := false;

    // ...
    PathVar := Registr.ReadString('PATH');
    // ...
    ParsePathString(PathVar,PathVarList);
    if PathVarList.Count > 0 then begin
      //      .      .
      I := -1;
      Finded := false;    //     ...
      repeat
        I := I+1;
        if UpperCase(DelLastSlash(PathVarList.Strings[I])) = UpperCase(DelLastSlash(PathStr)) then begin
          PathVarList.Delete(I);
          I := I-1;
          Finded := true;   //  % ).
        end;
      until I >= PathVarList.Count-1;

      //    ...
      //        -     
      //   ...
      if Finded = true then begin
        // ...
        PathVar := CombinePathString(PathVarList);
        if DoDebugOutput = true then begin
          //Writeln('New path will be: '+PathVar);
        end;
        //    ...
        Registr.WriteString('PATH',PathVar);           //  -   .
        //.
        Result := true;
      end;

    end;
  end;
  
begin

  //..
  Registr := TRegistry.Create;
  PathVarList := TStringList.Create;
  Result := false;
  
  //
  //...
  If CheckUser = true then begin
    Registr.RootKey := HKEY_CURRENT_USER;
    Registr.OpenKey('\Environment',false);
    Result := RemoverCode();
    Registr.CloseKey;
  end;
  
  //...
  If CheckGlobal = true then begin
    Registr.RootKey := HKEY_LOCAL_MACHINE;
    Registr.OpenKey('\SYSTEM\CurrentControlSet\Control\Session Manager\Environment',false);
    Result := Result or RemoverCode();
    Registr.CloseKey;
  end;
  
  //    - ...
  if Result = true then begin
    {$IFOPT H+} {$DEFINE NEED_HINTS_ON}{$HINTS OFF} {$ENDIF}   //     ,   .
    SendMessage( HWND_BROADCAST, WM_SETTINGCHANGE, 0, LPARAM(LPCSTR('Environment')) );
    {$IFDEF NEED_HINTS_ON} {$HINTS ON} {$ENDIF}
  end;
  
  // ...
  Registr.Free;
  PathVarList.Free;

end;

Function EnvPathAdd(const PathStr : string; const Target : integer; const ForceRemoveDoubles : boolean = true; const ForceCreateLocal : boolean = false) : boolean;
//    PATH.
var
  Registr : TRegistry;
  UserPathVar, GlobalPathVar : string;
  UserPathVarList, GlobalPathVarList : TStringList;
  Finded : boolean;
  
begin
  //..
  Registr := TRegistry.Create;
  Result := false;
  
  //,       ...
  if Target = EnvPathAdd_Global then begin
    //  
    
    //      .   - .
    EnvPathRemove(PathStr, true, false);
    
    //  -       ...
    Finded := EnvPathExists(PathStr, false, true);
    
    //    -  .   -     %).
    if Finded = false then begin
      Registr.RootKey := HKEY_LOCAL_MACHINE;
      Registr.OpenKey('\SYSTEM\CurrentControlSet\Control\Session Manager\Environment',true);
      // ...
      GlobalPathVar := Registr.ReadString('PATH');
      // ...
      GlobalPathVarList := TStringList.Create;
      ParsePathString(GlobalPathVar,GlobalPathVarList);
      // ...
      GlobalPathVarList.Add(PathStr);
      GlobalPathVar := CombinePathString(GlobalPathVarList);
      //  .
      if DoDebugOutput = true then begin
        //Writeln('New global path will be: '+GlobalPathVar);
      end;
      //    ...
      Registr.WriteString('PATH',GlobalPathVar);           //  -   .
      Registr.CloseKey;
      //    - ...
      {$IFOPT H+} {$DEFINE NEED_HINTS_ON}{$HINTS OFF} {$ENDIF}   //     ,   .
      SendMessage( HWND_BROADCAST, WM_SETTINGCHANGE, 0, LPARAM(LPCSTR('Environment')) );
      {$IFDEF NEED_HINTS_ON} {$HINTS ON} {$ENDIF}
      // ...
      GlobalPathVarList.Free;
    end;
  end
  else if Target = EnvPathAdd_User then begin
    //  

    //,       (     ),
    //      - .
    Finded := false;
    if ForceRemoveDoubles = true then begin
      // 
      EnvPathRemove(PathStr, false, true);
    end
    else if ForceCreateLocal = false then begin
      //   -   -        .
      Finded := EnvPathExists(PathStr, false, true);
    end;
    
    //     - ,      ...
    if Finded = false then begin
      Finded := EnvPathExists(PathStr, true, false);
    end;
    
    // ,         - .
    Registr.RootKey := HKEY_CURRENT_USER;
    Registr.OpenKey('\Environment',true);
    // ...
    UserPathVar := Registr.ReadString('PATH');
    // ...
    UserPathVarList := TStringList.Create;
    ParsePathString(UserPathVar,UserPathVarList);
    // ...
    UserPathVarList.Add(PathStr);
    UserPathVar := CombinePathString(UserPathVarList);
    //  .
    if DoDebugOutput = true then begin
      //Writeln('New user path will be: '+UserPathVar);
    end;
    //    ...
    Registr.WriteString('PATH',UserPathVar);           //  -   .
    Registr.CloseKey;
    //    - ...
    {$IFOPT H+} {$DEFINE NEED_HINTS_ON}{$HINTS OFF} {$ENDIF}   //     ,   .
    SendMessage( HWND_BROADCAST, WM_SETTINGCHANGE, 0, LPARAM(LPCSTR('Environment')) );
    {$IFDEF NEED_HINTS_ON} {$HINTS ON} {$ENDIF}
    // ...
    UserPathVarList.Free;
  end;

  // ...
  Registr.Free;
end;

Function TrimExLeft(const InputStr, TrimChars : string) : string;
//  .
var
  FindedTrimChar, FindedNoTrimChar : boolean;
  I, J : Integer;
  
begin

  //  .
  Result := '';
  
  //      -....
  if Length(InputStr) > 0 then begin
    //.          TrimChars...
    I := 0;
    FindedNoTrimChar := false;
    repeat
      //     .
      //      .
      I := I+1;
      FindedTrimChar := false;
      
      // 
      for J := 1 to Length(TrimChars) do begin
        //      %).
        if InputStr[I] = TrimChars[J] then begin
          FindedTrimChar := true;     //  .
        end;
      end;
      
      //  .
      if FindedTrimChar = false then begin
        //     -  ,    -  .
        FindedNoTrimChar := true;
      end;
      
    until (I = Length(InputStr)) or (FindedNoTrimChar = true);
    
    //      ...
    If FindedNoTrimChar = true then begin
      //    -    -   .
      //      -        -   .
      Result := RightStr(InputStr,Length(InputStr)-I+1);
    end;
  end;
  
end;

Function TrimExRight(const InputStr, TrimChars : string) : string;
//  .
var
  FindedTrimChar, FindedNoTrimChar : boolean;
  I, J : Integer;

begin

  //  .
  Result := '';

  //      -....
  if Length(InputStr) > 0 then begin
    //.          TrimChars...
    I := Length(InputStr)+1;
    FindedNoTrimChar := false;
    repeat
      //     .
      //      .
      I := I-1;
      FindedTrimChar := false;

      // 
      for J := 1 to Length(TrimChars) do begin
        //      %).
        if InputStr[I] = TrimChars[J] then begin
          FindedTrimChar := true;     //  .
        end;
      end;

      //  .
      if FindedTrimChar = false then begin
        //     -  ,    -  .
        FindedNoTrimChar := true;
      end;

    until (I = 1) or (FindedNoTrimChar = true);

    //      ...
    If FindedNoTrimChar = true then begin
      //    -    -   .
      //      -        -   .
      Result := LeftStr(InputStr,I);
    end;
  end;

end;

Function TrimEx(const InputStr, TrimChars : string) : string;
//    .
begin
  //    .
  Result := TrimExLeft(TrimExRight(InputStr, TrimChars), TrimChars);
end;

Function FileToCRC32(const FileName : string; const ConsoleOutput : boolean = false) : cardinal;
// CRC32  ,       .
const
  ReadBuffSize = 500000;              // 500  -          ...
                                      //...    linux-  wine.
var
  CurrStream : TFileStream;
  //Buffer : array [0..ReadBuffSize-1] of byte;    // ,   fpc (   ) -    .
  Buffer : array of byte;
  Readed, FullReaded : LongInt;
  
begin

  //  CRC
  Result := crc32(0, nil, 0);
  //    ...
  SetLength(Buffer,ReadBuffSize-1);

  //  ...
  if FileExists(FileName) = true then begin
    //    - ...
    
    // ...
    Readed := 0;
    FullReaded := 0;
    
    // ...
    CurrStream := TFileStream.Create(FileName,fmOpenRead);
    
    //  -      .
    if ConsoleOutput = true then begin
      Write('CRC32: '+FileName+' -> ');
    end;
    
    // .        .
    repeat
      Readed := CurrStream.Read(buffer[0],ReadBuffSize);
      FullReaded := FullReaded+Readed;
      Result := crc32(Result, @buffer[0], Readed);
    until Readed = 0;
    
    //.   .
    CurrStream.Free;
    //     CRC  ...
    if ConsoleOutput = true then begin
      Writeln(IntToHex(Result,8));
    end;
    
  end;
  
  // 
  SetLength(Buffer,0);
end;

Function CheckCharNum(const Ch : char) : boolean;
// -    
begin
  result := false;
  if Ch = '0' then result := true;
  if Ch = '1' then result := true;
  if Ch = '2' then result := true;
  if Ch = '3' then result := true;
  if Ch = '4' then result := true;
  if Ch = '5' then result := true;
  if Ch = '6' then result := true;
  if Ch = '7' then result := true;
  if Ch = '8' then result := true;
  if Ch = '9' then result := true;
end;

Function CheckStrInt(const St : string) : boolean;
// -      
var
  ch : char;
  I : integer;
  
begin
  If (st <> '') and (st<>'-') then begin
    result := true;
    I := 0;
    If St[I+1] = '-' then I := I+1;
    repeat
      I := I+1;
      Ch := St[I];
      if ch <> #0 then if CheckCharNum(Ch) = false then result := false;
    until Ch = #0;
  end
  else result := false;
end;

Function CheckStrFloat(const St : string) : boolean;
// -      
var
  zapatih, I : integer;
  ch : char;
  
begin
  If (st <> '') and (st <> 'NAN') and (st<>'-') then begin
    result := true;
    zapatih := 1;
    I := 0;
    If St[I+1] = '-' then I := I+1;
    repeat
      I := I+1;
      Ch := St[I];
      If ch = DecimalSeparator then zapatih := zapatih-1
      else if ch <> #0 then if CheckCharNum(Ch) = false then result := false;
    until Ch = #0;
    if zapatih < 0 then result := false;
  end
  else begin
    If St = 'NAN' then result := true
    else Result := false;
  end;
end;

Function IntToBool(const InputInt : Integer) : boolean;
// Integer  Boolean
begin
  If InputInt = 1 then begin
    Result := true;
  end
  else begin
    Result := false;
  end;
end;

Function StrToBool(const InputStr : AnsiString) : boolean;
// String  Boolean
begin
  //,    .
  If CheckStrInt(InputStr) = true then begin
    // - ,    ...
    Result := IntToBool(StrToInt(InputStr));
  end
  else begin
    //  - ,   false
    Result := false;
  end;
end;

Function BoolToInt(const InputBool : boolean) : Integer;
// Boolean  Integer
begin
  If InputBool = true then begin
    //true
    Result := 1;
  end
  else begin
    //false
    Result := 0;
  end;
end;

Function BoolToStr(const InputBool : boolean) : AnsiString;
// Boolean  String
begin
  Result := IntToStr(BoolToInt(InputBool));
end;

Function IsLocalPath(const PathStr : string) : boolean;
// true   ,  false  .
//      .
begin
  Result := false;   //     .
  
  if Length(PathStr) >= 1 then begin
    if PathStr[1] = '.' then begin
      Result := true;
    end;
  end;
end;

Function ReadFirstLineFromStr(const InputStr : AnsiString) : AnsiString;
//       #13  #10  #13  .
var
  EndStrPos13, EndStrPos10, EndStrPos : Integer;
begin
  //.
  Result := '';

  //     #13.
  EndStrPos13 := Longint( StrPos( PChar(InputStr), PChar(#13) ) - PChar(InputStr) + 1 ) ;
  if EndStrPos13 <= 0 then begin
    EndStrPos13 := Length( InputStr )+1;
  end;
  //  #10
  EndStrPos10 := Longint( StrPos( PChar(InputStr), PChar(#10) ) - PChar(InputStr) + 1 ) ;
  if EndStrPos10 <= 0 then begin
    EndStrPos10 := Length( InputStr )+1;
  end;
  //   .
  if EndStrPos10 < EndStrPos13 then begin
    EndStrPos := EndStrPos10;
  end
  else begin
    EndStrPos := EndStrPos13;
  end;

  //   .
  Result := Copy(InputStr,1,EndStrPos-1);
end;

//      .
function AddExtensionIfAbsent(const path, extension :String) :String;
var
  ex :AnsiString;
begin
  Result := path;
  ex := ExtractFileExt(path);
  if (ex = '') then begin
    Result := path + extension;
  end;
end;

//   ,  
function GetFileNameWithoutExtension(const path :String) :String;
var
  fileName :String;
  i        :Integer;
begin
  fileName := ExtractFileName(path);
  i := Length(FileName);
  while (i > 0) and (FileName[i] <> '.') do Dec(i);

  if (i > 0) then
    Result := Copy(FileName, 1, i - 1)
  else
    Result := fileName;


end;

end.

