////////////////////////////////////////////////////////////
//                 ,                 //
//                                    //
//               +                    //
//                     LCL-                        //
//                       v 1.3                            //
//                                                        //
//            Copyright (C) 2007-2010 Sagrer              //
//                                                        //
//                              //
//                  Modified LGPL v2.1                    //
//           .  COPYING.modifiedLGPL.txt            //
//                                                        //
//                  sagrer@yandex.ru                      //
////////////////////////////////////////////////////////////

//      , ....  :
// 1)  (Sagrer)  (sagrer@yandex.ru)

////////////////////////////////////////////////////////////////////////

unit LCLTextFileInString;
////////////////////////////////////////////////////////
//            TFileInString         //
//            -       //
//         ,           //
////////////////////////////////////////////////////////

{$mode objfpc}{$H+}

interface
uses LCLFileInString;

type
  TTextFileInString = class (TFileInString)
  public
    //       TFileInString
    Cursor : LongInt;
    //-
    constructor Create; override;                           //  %).
    Destructor Destroy; override;                           // .
    //
    Function Load(const FName : AnsiString) : boolean; override; //  .
    Procedure MakNewFile(); override;                              //"  " %).
    Procedure AddStr(const Str : AnsiString);
    Function ReadStrLn(const FirstByte : LongInt) : AnsiString;
    Function CurReadStr : AnsiString;
    Function CurReadLn : AnsiString;
    Function Eof : boolean;
    Function CurRead(const BytesRead : LongInt) : AnsiString;
    Procedure InsertString(const Pos : LongInt; Str : AnsiString);
    Procedure ReplaceString(const Pos : LongInt; Str : AnsiString);
  end;

implementation

////////////////////////////////////////
//        TTextFileInString           //
////////////////////////////////////////

//------------------------------------//
//      -      //
//------------------------------------//

Constructor TTextFileInString.Create;
//  %).
begin
  inherited;       //  ...
  //   ...
  Cursor := 1;
end;

Destructor TTextFileInString.Destroy;
begin
  // .
  inherited;
end;

//------------------------------------//
//                              //
//------------------------------------//

Function TTextFileInString.Load(const FName : AnsiString) : boolean;
//  .
begin
  Result := inherited;
  Self.Cursor := 1;
end;

Procedure TTextFileInString.MakNewFile();
//"  " %).
begin
  inherited;
  Self.Cursor := 1;
end;

Procedure TTextFileInString.AddStr(const Str : AnsiString);
begin
  FileString := FileString+Str+#13#10;
end;

Function TTextFileInString.ReadStrLn(const FirstByte : LongInt) : AnsiString;
var
  I, TempInt : LongInt;
begin
  //     .
  //  .

  //  -   .
  I := FirstByte;
  TempInt := Length(FileString);
  repeat
    If (FileString[I] <> #13) and (FileString[I] <> #10) and (FileString[I] <> #12) and (I <> TempInt+1) then begin
      I := I+1;
    end;
  until (FileString[I] = #13) or (FileString[I] = #10) or (FileString[I] = #12) or (I = TempInt+1);

  //    (   ).
  result := ReadStr(FirstByte,I-FirstByte);
end;

Function TTextFileInString.CurReadStr : AnsiString;
begin
  //     ,      .
  Result := ReadStrLn(Cursor);
  Cursor := Cursor+Length(Result);
end;

Function TTextFileInString.CurReadLn : AnsiString;
begin
  //     ,      . ,
  //   .
  Result := CurReadStr;
  If (Cursor <> Length(FileString)+1) and ((Length(FileString)+1)  - (Cursor) >=2) and (FileString[Cursor] = #13) then begin
    //     ,   #13,    2 , ...
    Cursor := Cursor+2;
  end
  else if (Cursor <> Length(FileString)+1) and ((Length(FileString)+1)  - (Cursor) >=1) and (FileString[Cursor] <> #13) then begin
    //     ,    #13    1 , ...
    Cursor := Cursor+1;
  end;
end;

Function TTextFileInString.Eof : boolean;
begin
  //     ,   ...

  result := false;  // ...

  If Cursor = Length(FileString)+1 then begin
    result := true;
  end
  else begin
    If Cursor > Length(FileString)+1 then begin
      //      ,
      // ,   ...
      Cursor := Length(FileString)+1;
      result := true;
    end;
  end;
end;

Function TTextFileInString.CurRead(const BytesRead : LongInt) : AnsiString;
begin
  //,        ,
  //   .

  result := ReadStr(Cursor,BytesRead);
  Cursor := Cursor+BytesRead;
end;

Procedure TTextFileInString.InsertString(const Pos : LongInt; Str : AnsiString);
var
  TempStr : AnsiString;
begin
  //,   (    -  
  // -   ) .

  TempStr := ReadStr(1,Pos-1); //     .
  TempStr := TempStr+Str;  // ...
  If Pos-1 <> Length(FileString) then begin
    //    ...
    TempStr := TempStr+ReadStr(Pos,Length(FileString)-Pos+1);  //  .
  end;  
  FileString := TempStr;
end;

Procedure TTextFileInString.ReplaceString(const Pos : LongInt; Str : AnsiString);
var
  TempStr, buf : AnsiString;
  TempPos : LongInt;
begin
  //   (    )
  //   (  #13#10     ...)
  TempStr := ReadStr(1,Pos-1); //     .
  TempStr := TempStr+Str;  // ...
  If Pos-1 <> Length(FileString) then begin
    //    ...
    buf := ReadStrLn(Pos);    //  ,    
    //  ,    .
    TempPos := Pos+Length(buf);

    TempStr := TempStr+ReadStr(TempPos,Length(FileString)-TempPos+1);  //  .
  end;
  FileString := TempStr;
end;

end.
