///////////////////////////////////////////////////////////
//                    MOExtractor                        //
//       -  MOFile        //
//                     gettext.                  //
//               //
//           mo-,         //
//                //
//             .          //
//                                                       //
//              Copyright (C) 2008-2010 Sagrer           //
//                                                       //
//                             //
//                  Modified LGPL v2.1                   //
//           .  COPYING.modifiedLGPL.txt           //
//                                                       //
//                    0.2                    //
//                                                       //
//                   sagrer@yandex.ru                    //
///////////////////////////////////////////////////////////

//      , ....  :
// 1)  (Sagrer)  (sagrer@yandex.ru)

////////////////////////////////////////////////////////////////////////

unit MOExtractor;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, gettext, ExtraFileUtilsLCL, LConvEncoding;
  
type
  TMOExtractor = class(TMOFile)    //     mo.
  private
  protected
    // 
    CurrLang : String;                   // 
    CurrFallbackLang : String;           //    
    CurrEncoding : String;               // 
    MODir : String;                      //  *.mo-.
    MOPref : String;                     //   *.mo-.
    IsDummy : Boolean;                   //         *.mo.
  public
    // .
    LangConnected : Boolean;             //  *.mo  .
    
    //-
    constructor Create(const MODirectory, MOPrefix : String; const DefLang : String = 'default');  virtual;    //,    {MODirectory}\{MOPrefix}{lang}.mo,   {lang}.
    constructor CreateAsDummy;  virtual;  //,  -,     ,  .

    // .
    function _(AOrig: String) : String; virtual;      //  ,     .
    function GetCurrLang : String;    //   .
  end;
  
// 
function GetUIEncoding: string;    //Gets encoding for a user interface - it may not be the same as a system encoding.

implementation

/////////////////////////////////////////////
//          TConsUtilServiceClass          //
/////////////////////////////////////////////

//-----------------------------------------//
//        -...      //
//-----------------------------------------//

constructor TMOExtractor.Create(const MODirectory, MOPrefix : String; const DefLang : String = 'default');
//,    {MODirectory}\{MOPrefix}{lang}.mo,   {lang}.
begin
  //  ...
  Self.MODir := MODirectory;
  Self.MOPref := MOPrefix;
  //  ...
  GetLanguageIDs(CurrLang, CurrFallbackLang);
  if DefLang <> 'default' then begin
    //     -   .
    CurrFallbackLang := DefLang;
  end;
  // ...
  CurrEncoding := GetUIEncoding();
  //   -  
  Self.IsDummy := false;
  // -     ?
  if FileExists(AddLastSlash(MODirectory)+MOPrefix+CurrFallbackLang+'.mo') = true then begin
    // .
    //      .
    Self.LangConnected := true;
    try
      inherited Create(AddLastSlash(MODirectory)+MOPrefix+CurrFallbackLang+'.mo');
    except
      //   -       .
      Self.LangConnected := false;
    end;
  end
  else begin
    //   -      "    "
    Self.LangConnected := false;
  end;
end;

constructor TMOExtractor.CreateAsDummy();
//,  -,     ,  .
begin
  //-     ,  ...
  GetLanguageIDs(CurrLang, CurrFallbackLang);
  CurrEncoding := GetDefaultTextEncoding();
  //,     ...
  Self.LangConnected := false;
  Self.IsDummy := true;
end;

//-----------------------------------------//
//              .            //
//-----------------------------------------//

function TMOExtractor._(AOrig: String) : String;
//  ,     .
begin
  if (Self.LangConnected = true) and (Self.IsDummy = false) then begin
    //  ...
    Result := ConvertEncoding(Self.Translate(AOrig),'utf-8',Self.CurrEncoding);
    //  mo     -  .
    if (Result = '') and (AOrig <> '') then Result := AOrig;
  end
  else begin
    //    -    ,  .
    Result := AOrig;
  end;
end;

function TMOExtractor.GetCurrLang() : String;
//   .
begin
  Result := Self.CurrFallbackLang;
end;

/////////////////////////////////////////////
//                        //
/////////////////////////////////////////////

function GetUIEncoding: string;
//Gets encoding for a user interface - it may not be the same as a system encoding.
begin
  Result := GetDefaultTextEncoding;
  {$IFDEF Windows}
  if System.IsConsole = true then begin
    if Result = 'cp1251' then begin
      //Russian versions of Windows 9x-XP use a cp866 encoding for console i\o.
      Result := 'cp866';
    end;
  end;
  {$ENDIF}
end;

end.

