////////////////////////////////////////////////////////////
//                  *.ini                  //
//                        v 1.7                           //
//                                                        //
//            Copyright (C) 2007-2010 Sagrer              //
//                                                        //
//                              //
//                  Modified LGPL v2.1                    //
//           .  COPYING.modifiedLGPL.txt            //
//                                                        //
//                     LCL-.                       //
//                                                        //
//                  sagrer@yandex.ru                      //
////////////////////////////////////////////////////////////

//      , ....  :
// 1)  (Sagrer)  (sagrer@yandex.ru)

////////////////////////////////////////////////////////////////////////

//  -     .  
// -  ,  " " .
//  -       Delphi 5 , 
//   ini-  ,      
//ini-         , 
//  ... -      .

unit LCLAnIniFile;

{$mode objfpc}{$H+}

interface
uses LCLTextFileInString, SysUtils, ExtraFunctionsLcl, Classes;

type
  RIniValueListElement = record             //   ini       .
    Name : string;
    Value : string;
  end;
  
  AIniValueListElements = array of RIniValueListElement;   //   -   IniValueList

  AIniValueList = array of AIniValueListElements;     //        IniValueList -           ,     ,     .
  
  TAnIniFile = class (TObject)              //         ( *.iss) ini-.
    Public
      //
      TextFil1 : TTextFileInString;
      
      //-...
      Constructor Create; virtual;
      Destructor Destroy; override;
      
      // ...
      Function Load(const FileName : string) : boolean;      //    
      Function Save(const FileName : string) : boolean;      //      
      Function SectionExists(const SectName : string) : boolean;    //  
      Function ElementExists(const SectName, ElemName : string) : boolean;    //  
      Function ReadString(const SectName, ElemName : string) : string;  //  
      Function ReadInteger(const SectName, ElemName : string) : integer;    //  
      Function ReadFloat(const SectName, ElemName : string) : Extended;    //  
      Function ReadBool(const SectName, ElemName : string) : boolean;     //  
      Procedure WriteString(const SectName, ElemName, Str : string);     //  
      Procedure WriteInteger(const SectName, ElemName : string; Int : integer);   //  
      Procedure WriteFloat(const SectName, ElemName : string; Flt : Extended);   //  
      Procedure WriteBool(const SectName, ElemName : string; Bool : boolean);   //  
      Procedure MakNewFile(); virtual;       // " "
      Procedure CreateSection(const SectName : string);            //  .
      Procedure RemoveSection(const SectName : string); virtual;   //  .
      Function ReadRawSection(const SectName : string) : string;   //      .
      Function ReadSectionStrings(const SectName : string) : string;    //      ,    - .
      Procedure WriteRawSection(const SectName, SectContent : string);   virtual; //     .
      Procedure StrToIniValueList(const InputStr : string; var IniValueList : AIniValueList);  //       .
      Function IniValueListToStr(var IniValueList : AIniValueList) : string;   //     .
      Procedure ReadIniValueList(const SectName : string; var IniValueList : AIniValueList);  // IniValueList  .
      Procedure WriteIniValueList(const SectName : string; var IniValueList : AIniValueList);  //    IniValueList.
      Function CompareIniValueElements(var IniValueList1, IniValueList2 : AIniValueList; const List1Index, List2Index : Integer; const CaseSensitive : boolean; const ExceptValueNames : AnsiString) : Boolean;   //  2  2  ,    (   -   ) -  true,  false.    Except - "all"    -    ,  .
      Function CompareIniValueLists(var IniValueList1, IniValueList2 : AIniValueList; const CaseSensitive : boolean; const ExceptValueNames : AnsiString) : Boolean;  //  2  ,    (   -   ) -  true,  false.    Except - "all"    -    ,  .
      Function GetIniValueListValueIndex(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName : AnsiString) : Integer;   //          ().
      Function GetIniValueListValue(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName : AnsiString) : AnsiString;   //          .
      Function ChangeIniValueListValue(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName, ValueValue : AnsiString) : Boolean;   //            .
      Function IniValueListValueExists(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName : AnsiString) : Boolean;   //   -  true,  false.
      Function GetIniValueListIndexByValue(var IniValueList : AIniValueList; const ValueName, ValueValue : AnsiString) : Integer;     //     ()       .     -  -1.
      Function CopyIniValueListElement(var From, Dest : AIniValueList; const FromIndex, DestIndex : Integer) : Boolean;  //           (                 .).
      Function CopyIniValueList(var From, Dest : AIniValueList) : Boolean;   //     .
      Function AddIniValueList(var From, Dest : AIniValueList) : Boolean;   //     ,             .
      Function RemoveIniValueListValue(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName : AnsiString) : Boolean;     //         IniValueList.      -  false,  true.
      Function RemoveIniValueListElement(var IniValueList : AIniValueList; const ValIndex : Integer) : Boolean;        //   IniValueList.     -  false,    true.
    Private
      // ...
      Function GoToSection(const SectName : string; TypePos : byte) : boolean;    //       
      Function GoToElement(const SectName, ElemName : string) : boolean;    //    
      Function NotComment(const Str : string) : boolean;     // -    
      Function GetElemName(const Str : string) : string;    //  
      Function GetElemStr(const Str : string) : string;     //   
      
  end;

implementation

/////////////////////////////////////////////
//              TAnIniFile                 //
/////////////////////////////////////////////

//-----------------------------------------//
//        -...      //
//-----------------------------------------//

Constructor TAnIniFile.Create;
begin
  //.   .
  TextFil1 := TTextFileInString.Create;
end;

Destructor TAnIniFile.Destroy;
begin
  // .
  TextFil1.Free;
  inherited;
end;

//------------------------------------------//
//              ...             //
//------------------------------------------//

Function TAnIniFile.Load(const FileName : string) : boolean;
begin
  //    -.
  Result := TextFil1.Load(FileName);
end;

Function TAnIniFile.Save(const FileName : string) : boolean;
begin
  //  -  .
  TextFil1.Save(FileName);
  Result := true;
end;

Function TAnIniFile.SectionExists(const SectName : string) : boolean;
var
  TempCur : Longint;
begin
  //,    .     :)

  TempCur := TextFil1.Cursor;
  Result := GoToSection(SectName,1);
  TextFil1.Cursor := TempCur;

end;

Function TAnIniFile.ElementExists(const SectName, ElemName : string) : boolean;
var
  TempCur : Longint;
begin
  //,    .    .

  TempCur := TextFil1.Cursor;
  Result := GoToElement(SectName,ElemName);
  TextFil1.Cursor := TempCur;
end;

Function TAnIniFile.ReadString(const SectName, ElemName : string) : string;
begin
  //      .
  Result := '';   //    :)

  //   .
  If GoToElement(SectName,ElemName) = true then begin
    // -     (   ).
    Result := GetElemStr(TextFil1.ReadStrLn(TextFil1.Cursor));
  end;
end;

Function TAnIniFile.ReadInteger(const SectName, ElemName : string) : integer;
var
  TempStr : string;
begin
  //      .
  TempStr := ReadString(SectName,ElemName);

  //,    .
  If CheckStrInt(TempStr) = true then begin
    // - ,   ...
    Result := StrToInt(TempStr);
  end
  else begin
    //  - ,   
    Result := 0;
  end;
end;

Function TAnIniFile.ReadFloat(const SectName, ElemName : string) : Extended;
var
  TempStr : string;
  SystemSeparator : Char;  //      .

begin
  //     .
  SystemSeparator := DecimalSeparator;
  DecimalSeparator := ',';

  //      .
  TempStr := ReadString(SectName,ElemName);

  //,    .
  If CheckStrFloat(TempStr) = true then begin
    // - ,   ...
    Result :=StrToFloat(TempStr);
  end
  else begin
    //  - ,   
    Result := 0;
  end;

  //   .
  DecimalSeparator := SystemSeparator;
end;

Function TAnIniFile.ReadBool(const SectName, ElemName : string) : boolean;
//      .
begin
  Result := StrToBool(ReadString(SectName,ElemName));
end;

Procedure TAnIniFile.WriteString(const SectName, ElemName, Str : string);
begin
  //   -   ,   ,
  //     .    ,  
  //,       .
  //     .    
  // .  (    )
  //   ,   ...

  //,   - ,   .
  If GoToElement(SectName,ElemName) = true then begin
    //  .    ...
    TextFil1.ReplaceString(TextFil1.Cursor,ElemName+'='+Str);
  end
  else begin
    //   .  ,      ...
    If GoToSection(SectName,3) = true then begin
      // ,    ,      ...
    end
    else begin
      //,      :).
      //      
      //   ...

      If TextFil1.Siz <> 0 then begin
        //,     .
        TextFil1.Cursor := TextFil1.Siz+1;    //   ...
        If TextFil1.FileString[TextFil1.Cursor-1] = #10 then begin
          //   -   
          //    
          //  1   ,       .
          //           
          //   #13#10     .
          If TextFil1.Siz > 3 then begin
            If TextFil1.FileString[TextFil1.Cursor-3] <> #10 then begin
              TextFil1.AddStr('');
            end;
          end;
          TextFil1.AddStr('['+SectName+']');
          TextFil1.Cursor := TextFil1.Siz+1;  //    .
        end
        else begin
          //  -    ( )
          // -   ,  ,    
          TextFil1.AddStr(#13+#10+#13+#10+'['+SectName+']'); //     
                                    //   ,     
          TextFil1.Cursor := TextFil1.Siz+1;  //    .
        end;
      end
      else begin
        //   ,       :))
        TextFil1.AddStr('['+SectName+']');
        TextFil1.Cursor := TextFil1.Siz+1;  //    .
      end;
    end;

    //  ,     ,     
    //   -       .
    //       (..    
    //,     ...

    TextFil1.InsertString(TextFil1.Cursor,ElemName+'='+Str+#13+#10);

  end;
end;

Procedure TAnIniFile.WriteInteger(const SectName, ElemName : string; Int : integer);
begin
  //   ,    .
  WriteString(SectName,ElemName,IntToStr(Int));
end;

Procedure TAnIniFile.WriteFloat(const SectName, ElemName : string; Flt : Extended);
var
  SystemSeparator : Char;  //      .
begin
  //     .
  SystemSeparator := DecimalSeparator;
  DecimalSeparator := ',';

  //   ,    .
  WriteString(SectName,ElemName,FloatToStr(Flt));

  //   .
  DecimalSeparator := SystemSeparator;
end;

Procedure TAnIniFile.WriteBool(const SectName, ElemName : string; Bool : boolean);
begin
  //
  WriteString(SectName,ElemName,BoolToStr(Bool));
end;

Procedure TAnIniFile.MakNewFile();
begin
  //"  " ;)
  //   -  TextFil1

  TextFil1.MakNewFile;
end;

Procedure TAnIniFile.CreateSection(const SectName : string);
//  .
begin

  if SectionExists(SectName) = false then begin
    //     - .
    //      .
    If TextFil1.Siz <> 0 then begin
      //,     .
      TextFil1.Cursor := TextFil1.Siz+1;    //   ...
      If TextFil1.FileString[TextFil1.Cursor-1] = #10 then begin
        //   -   
        //    
        //  1   ,       .
        //           
        //   #13#10     .
        If TextFil1.Siz > 3 then begin
          If TextFil1.FileString[TextFil1.Cursor-3] <> #10 then begin
            TextFil1.AddStr('');
          end;
        end;
        TextFil1.AddStr('['+SectName+']');
        TextFil1.Cursor := TextFil1.Siz+1;  //    .
      end
      else begin
        //  -    ( )
        // -   ,  ,    
        TextFil1.AddStr(#13+#10+#13+#10+'['+SectName+']'); //     
                                  //   ,     
        TextFil1.Cursor := TextFil1.Siz+1;  //    .
      end;
    end
    else begin
      //   ,       :))
      TextFil1.AddStr('['+SectName+']');
      TextFil1.Cursor := TextFil1.Siz+1;  //    .
    end;
  end;
  
end;

Procedure TAnIniFile.RemoveSection(const SectName : string);
//  .
var
  TempCursor1 : LongInt;

begin

  //     ....
  if SectionExists(SectName) = true then begin
    //    ...
    GoToSection(SectName,1);
    TempCursor1 := TextFil1.Cursor;
    //    ...
    GoToSection(SectName,3);
    //      ...
    Delete(TextFil1.FileString, TempCursor1, TextFil1.Cursor-TempCursor1);
  end;
  
  //       .
  TextFil1.Cursor := 1;
  
end;

Function TAnIniFile.ReadRawSection(const SectName : string) : string;
//      .
var
  TempCursor1, TempCursor2 : LongInt;
  
begin
  //    ...
  Result := '';

  //     ....
  if SectionExists(SectName) = true then begin
    //   ...
    TempCursor2 := TextFil1.Cursor;
    //    ...
    GoToSection(SectName,2);
    TempCursor1 := TextFil1.Cursor;
    //    ...
    GoToSection(SectName,3);
    //     ...
    //    ...
    if (TextFil1.Cursor-TempCursor1) > 0 then begin
      Result := Copy(TextFil1.FileString, TempCursor1, TextFil1.Cursor-TempCursor1);
    end;
    //   .
    TextFil1.Cursor := TempCursor2;
  end;
  
end;

Function TAnIniFile.ReadSectionStrings(const SectName : string) : string;
//      ,    - .
var
  TempStringList : TStringList;
  I : Integer;

begin
  //
  TempStringList := TStringList.Create;
  //    ...
  Result := '';

  //     ....
  if SectionExists(SectName) = true then begin
    //  ...
    TempStringList.SetText(PChar(Self.ReadRawSection(SectName)));
    //  .
    For I := 0 to TempStringList.Count-1 do begin
      if Self.NotComment(TempStringList.Strings[I]) = true then begin
        //    -    .
        if Result <> '' then Result := Result+#13+#10+TempStringList.Strings[I]
        else Result := TempStringList.Strings[I];
      end;
    end;
  end;
  
  // .
  TempStringList.Free;
end;

Procedure TAnIniFile.WriteRawSection(const SectName, SectContent : string);
//     .
begin

  //    ...
  RemoveSection(SectName);
  
  //   ...
  CreateSection(SectName);
  //     ...   CreateSection        ...
  TextFil1.FileString := TextFil1.FileString+SectContent;

end;

Procedure TAnIniFile.StrToIniValueList(const InputStr : string; var IniValueList : AIniValueList);
//       .
var
  Strings, Elements, I, J, RealStrings, StrsAdded, ElementsAdded : Integer;
  TrimmedStr, CurrStr, ElementStr : string;
  Done : boolean;
  
begin
  //
  Done := false;
  //  -     ...
  TrimmedStr := TrimEx(InputStr,' '+#13+#10);
  
  //   -  ...
  if Length(TrimmedStr) = 0 then begin
    // .        .
    SetLength(IniValueList,0,0);
    Done := true;
  end;
  
  // .
  if Done = false then begin

    //  .
    Strings := 1;   //  1    .
    I := 0;   //   1- .
    repeat
      I := I+1;
      if TrimmedStr[I] = #10 then begin
        Strings := Strings+1;
      end;
    until I = Length(TrimmedStr);

    //.      (1- )...
    SetLength(IniValueList,Strings);
    
    //   ...
    //  ...
    RealStrings := Strings;
    StrsAdded := 0;
    for I := 1 to Strings do begin
      //   ....
      CurrStr := {TrimRight(}Parse(TrimmedStr,#13+#10){)};
      //     ...
      TrimExLeft(TrimmedStr,' '+#13+#10);
      
      // .  ,    ...
      if NotComment(CurrStr) = true then begin
        //  - .

        //      .
        Elements := 1;  //  1    .
        J := 0;  //  1- .
        repeat
          J := J+1;
          if CurrStr[J] = ';' then begin
            //  .
            Elements := Elements+1;
          end;
        until J = Length(CurrStr);

        //   ...
        SetLength(IniValueList[StrsAdded],Elements);
        
        // ...
        ElementsAdded := -1;       //   0- .
        repeat
          ElementsAdded := ElementsAdded+1;
          ElementStr := Trim(Parse(CurrStr,';'));  //  ...
          IniValueList[StrsAdded,ElementsAdded].Name := TrimRight(Parse(ElementStr,':'));  // 
          IniValueList[StrsAdded,ElementsAdded].Value := TrimLeft(ElementStr);  // 
        until Length(CurrStr) = 0;
        
        //   .
        StrsAdded := StrsAdded+1;
      end
      else begin
        // -    ,    ...
        RealStrings := RealStrings-1;
        SetLength(IniValueList,RealStrings);
      end;

    end;
    
  end;
  
end;

Function TAnIniFile.IniValueListToStr(var IniValueList : AIniValueList) : string;
//     .
var
  I, J : Integer;
begin
  //      ...
  Result := '';          // 
  
  if Length(IniValueList) > 0 then begin

    for I := 0 to Length(IniValueList)-1 do begin

      // 
      for J := 0 to Length(IniValueList[I])-1 do begin
        Result := Result+IniValueList[I,J].Name+': '+IniValueList[I,J].Value;
        if J <> Length(IniValueList[I])-1 then begin
          //    -   
          Result := Result+'; ';
        end;
      end;
      
      //    -   .
      if I <> Length(IniValueList)-1 then begin
        Result := Result+#13+#10;
      end;
    end;
    
  end;
  
  // -   %).
end;

Procedure TAnIniFile.ReadIniValueList(const SectName : string; var IniValueList : AIniValueList);
// IniValueList  .
begin
  StrToIniValueList(ReadRawSection(SectName),IniValueList);
end;

Procedure TAnIniFile.WriteIniValueList(const SectName : string; var IniValueList : AIniValueList);
//    IniValueList.
begin
  WriteRawSection(SectName,IniValueListToStr(IniValueList));
end;

Function TAnIniFile.CompareIniValueElements(var IniValueList1, IniValueList2 : AIniValueList; const List1Index, List2Index : Integer; const CaseSensitive : boolean; const ExceptValueNames : AnsiString) : Boolean;
//  2  2  ,    (   -
//  ) -  true,  false.    Except - "all"  
// -    ,  .
var
  I, J, ElI : Integer;
  ExceptsList : TStringList;
  ExceptAll, CanCheck : Boolean;

begin
  //.
  Result := true;   //     .
  ExceptAll := false;   //   .
  ExceptsList := TStringList.Create;

  //  ...
  ExtractStrings([','],[' '],PChar(ExceptValueNames),ExceptsList);
  //  ....
  if ExceptsList.Count > 0 then begin
    if LowerCase(ExceptsList.Strings[0]) = 'all' then begin
      //,   .
      ExceptAll := true;
      //  "all".
      ExceptsList.Delete(0);
    end;
  end;

  // 1- ...
  for I := 0 to Length(IniValueList1[List1Index])-1 do begin

    //,    .
    if ExceptAll = false then begin
      //   " , ..."
      CanCheck := true;
      for ElI := 0 to ExceptsList.Count-1 do begin
        if LowerCase(IniValueList1[List1Index,I].Name) = LowerCase(ExceptsList.Strings[ElI]) then begin
          //   .
          CanCheck := false;
          Break;
        end;
      end;
    end
    else begin
      //   " , ..."
      CanCheck := false;
      for ElI := 0 to ExceptsList.Count-1 do begin
        if LowerCase(IniValueList1[List1Index,I].Name) = LowerCase(ExceptsList.Strings[ElI]) then begin
          //   __ .
          CanCheck := true;
          Break;
        end;
      end;
    end;

    //,       -  ...        ,      .
    if CanCheck = true then begin
      Result := false;   //   -  true.      false.
      for J := 0 to Length(IniValueList2[List2Index])-1 do begin
        // %).
        if LowerCase(IniValueList1[List1Index,I].Name) = LowerCase(IniValueList2[List2Index,J].Name) then begin
          //,      .    .
          //    -.
          if CaseSensitive = true then begin
            // .
            if IniValueList1[List1Index,I].Value = IniValueList2[List2Index,J].Value then begin
              //, , true.
              Result := true;
              //  -       if CanCheck = true then begin
              Break;
            end;
          end
          else begin
            //  .
            if LowerCase(IniValueList1[List1Index,I].Value) = LowerCase(IniValueList2[List2Index,J].Value) then begin
              //, , true.
              Result := true;
              //  -       if CanCheck = true then begin
              Break;
            end;
          end;
        end;
      end;
      //,  - true   false.  false   ,       
      //   false.
      if Result = false then begin
        Break;
      end;
    end;

  end;

  //,  1- .  Result   true -   2-, .
  if Result = true then begin
    for I := 0 to Length(IniValueList2[List2Index])-1 do begin

      //,    .
      if ExceptAll = false then begin
        //   " , ..."
        CanCheck := true;
        for ElI := 0 to ExceptsList.Count-1 do begin
          if LowerCase(IniValueList2[List2Index,I].Name) = LowerCase(ExceptsList.Strings[ElI]) then begin
            //   .
            CanCheck := false;
            Break;
          end;
        end;
      end
      else begin
        //   " , ..."
        CanCheck := false;
        for ElI := 0 to ExceptsList.Count-1 do begin
          if LowerCase(IniValueList2[List2Index,I].Name) = LowerCase(ExceptsList.Strings[ElI]) then begin
            //   __ .
            CanCheck := true;
            Break;
          end;
        end;
      end;

      //,       -  ...        ,      .
      if CanCheck = true then begin
        Result := false;   //   -  true.      false.
        for J := 0 to Length(IniValueList1[List1Index])-1 do begin
          // %).
          if LowerCase(IniValueList2[List2Index,I].Name) = LowerCase(IniValueList1[List1Index,J].Name) then begin
            //,      .    .
            //    -.
            if CaseSensitive = true then begin
              // .
              if IniValueList2[List2Index,I].Value = IniValueList1[List1Index,J].Value then begin
                //, , true.
                Result := true;
                //  -       if CanCheck = true then begin
                Break;
              end;
            end
            else begin
              //  .
              if LowerCase(IniValueList2[List2Index,I].Value) = LowerCase(IniValueList1[List1Index,J].Value) then begin
                //, , true.
                Result := true;
                //  -       if CanCheck = true then begin
                Break;
              end;
            end;
          end;
        end;
        //,  - true   false.  false   ,       
        //   false.
        if Result = false then begin
          Break;
        end;
      end;

    end;
  end;

  // .
  ExceptsList.Free;
end;

Function TAnIniFile.CompareIniValueLists(var IniValueList1, IniValueList2 : AIniValueList; const CaseSensitive : boolean; const ExceptValueNames : AnsiString) : Boolean;
//  2  ,    (   -  
//) -  true,  false.    Except - "all"    -  
// ,  .
var
  I, J : Integer;
  IdentElemFinded : Boolean;
begin
  //.
  Result := true;      //     ...

  //  .
  if Length(IniValueList1) <> Length(IniValueList2) then begin
    Result := false;
  end;

  if (Result = true) and (Length(IniValueList1) > 0) then begin
    //    -     .
    for I := 0 to Length(IniValueList1)-1 do begin

      //    ,  ...
      IdentElemFinded := false;
      for J := 0 to Length(IniValueList2)-1 do begin
        IdentElemFinded := false;   //      .
        if CompareIniValueElements(IniValueList1, IniValueList2, I, J, CaseSensitive, ExceptValueNames) = true then begin
          //  .     .
          IdentElemFinded := true;
          Break;
        end;
      end;

      // -      -   false  ,     ...
      if IdentElemFinded = false then begin
        Result := false;
        Break;
      end;
    end;
  end;
end;

Function TAnIniFile.GetIniValueListValueIndex(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName : AnsiString) : Integer;
//          ().
var
  I : Integer;
  TempValName : AnsiString;

begin
  //.
  TempValName := LowerCase(ValueName);
  Result := -1;

  //    .
  for I := 0 to Length(IniValueList[ValIndex])-1 do begin
    if LowerCase(IniValueList[ValIndex,I].Name) = TempValName then begin
      Result := I;
      Break;
    end;
  end;
end;

Function TAnIniFile.GetIniValueListValue(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName : AnsiString) : AnsiString;
//          .
var
  I : Integer;

begin
  //.
  Result := '';

  //    .
  I := Self.GetIniValueListValueIndex(IniValueList,ValIndex,ValueName);
  if I >= 0 then begin
    Result := IniValueList[ValIndex,I].Value;
  end;
end;

Function TAnIniFile.ChangeIniValueListValue(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName, ValueValue : AnsiString) : Boolean;
//            .
var
  I : Integer;
  TempValName : AnsiString;

begin
  //.
  TempValName := LowerCase(ValueName);
  Result := false;

  // .
  for I := 0 to Length(IniValueList)-1 do begin
    if LowerCase(IniValueList[ValIndex,I].Name) = TempValName then begin
      //,  .
      IniValueList[ValIndex,I].Value := ValueValue;
      Result := true;
      Break;
    end;
  end;

end;

Function TAnIniFile.IniValueListValueExists(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName : AnsiString) : Boolean;
//   -  true,  false.
var
  I : Integer;
  TempValName : AnsiString;

begin
  //.
  TempValName := LowerCase(ValueName);
  Result := false;

  // .
  for I := 0 to Length(IniValueList)-1 do begin
    if LowerCase(IniValueList[ValIndex,I].Name) = TempValName then begin
      //,   .   .
      Result := true;
      Break;
    end;
  end;
end;

Function TAnIniFile.GetIniValueListIndexByValue(var IniValueList : AIniValueList; const ValueName, ValueValue : AnsiString) : Integer;
//     ()       .
//    -  -1.
var
  I, ValueNum : Integer;
  TempValueStr : AnsiString;
  
begin
  //.
  Result := -1;

  //     .
  TempValueStr := LowerCase(ValueValue);
  //      .
  for I := 0 to Length(IniValueList)-1 do begin
    // -       ?
    ValueNum := Self.GetIniValueListValueIndex(IniValueList,I,ValueName);
    if ValueNum >= 0 then begin
      //,    .  -      ?
      if LowerCase(IniValueList[I,ValueNum].Value) = TempValueStr then begin
        //,     .  ,  .
        Result := I;
        Break;
      end;
    end;
  end;
  
end;

Function TAnIniFile.CopyIniValueListElement(var From, Dest : AIniValueList; const FromIndex, DestIndex : Integer) : Boolean;
//           (  
//              .).
var
  I : Integer;
begin
  //.
  Result := false;

  //  ...
  SetLength(Dest[DestIndex],Length(From[FromIndex]));
  // ...
  for I := 0 to Length(From[FromIndex])-1 do begin
    Dest[DestIndex,I].Name := From[FromIndex,I].Name;
    Dest[DestIndex,I].Value := From[FromIndex,I].Value;
  end;
  //  .
  Result := true;
end;

Function TAnIniFile.CopyIniValueList(var From, Dest : AIniValueList) : Boolean;
//     .
var
  I : Integer;
begin
  //.
  Result := true;

  //  ...
  SetLength(Dest, 0, 0);
  // .     ...
  SetLength(Dest, Length(From));
  //   ...
  for I := 0 to Length(From)-1 do begin
    //  .
    if Self.CopyIniValueListElement(From, Dest, I, I) = false then begin
      //    -  -   ,  false.
      Result := false;
      Break;
    end;
  end;
end;

Function TAnIniFile.AddIniValueList(var From, Dest : AIniValueList) : Boolean;
//     ,     
//       .
var
  I, OldDestLength : Integer;
begin
  //.
  Result := true;

  //   ...
  OldDestLength := Length(Dest);
  SetLength(Dest, Length(Dest)+Length(From));
  //   ...
  for I := 0 to Length(From)-1 do begin
    //  .
    if Self.CopyIniValueListElement(From, Dest, I, OldDestLength+I) = false then begin
      //    -  -   ,  false.
      Result := false;
      Break;
    end;
  end;
end;

Function TAnIniFile.RemoveIniValueListValue(var IniValueList : AIniValueList; const ValIndex : Integer; const ValueName : AnsiString) : Boolean;
//         IniValueList.
//     -  false,  true.
var
  I, ValuesNum : Integer;
  DeletingValue, DummyValue : RIniValueListElement;
  
begin
  //.
  Result := false;
  ValuesNum := Length(IniValueList[ValIndex]);
  DeletingValue.Name := '';
  DummyValue.Name := '';

  //   ?     .
  I := Self.GetIniValueListValueIndex(IniValueList,ValIndex,ValueName);
  if I >= 0 then begin
    //,    .
    //     -         .
    if I <> ValuesNum-1 then begin
      Move(IniValueList[ValIndex,I],DeletingValue,SizeOf(RIniValueListElement));    //    .
      Move(IniValueList[ValIndex,I+1],IniValueList[ValIndex,I],SizeOf(RIniValueListElement)*(ValuesNum-(I+1)));    //   .
      Move(DeletingValue,IniValueList[ValIndex,ValuesNum-1],SizeOf(RIniValueListElement));     //             (   ).
      Move(DummyValue,DeletingValue,SizeOf(RIniValueListElement));     //       -                  (..     )  .
    end;
    //  .
    IniValueList[ValIndex,ValuesNum-1].Name := '';
    IniValueList[ValIndex,ValuesNum-1].Value := '';
    //  .
    ValuesNum := ValuesNum-1;
    SetLength(IniValueList[ValIndex],ValuesNum);
    //Done.
    Result := true;
  end;
end;

Function TAnIniFile.RemoveIniValueListElement(var IniValueList : AIniValueList; const ValIndex : Integer) : Boolean;
//   IniValueList.     -  false,    true.
var
  I, ValuesNum, ElementsNum : Integer;
  DeletingElement, DummyElement : AIniValueListElements;
  
begin
  //.
  Result := false;
  DeletingElement := nil;      //          .
  SetLength(DummyElement,0);
  
  if Length(IniValueList) >= ValIndex then begin
    //..        .
    //  -   .
    ValuesNum := Length(IniValueList[ValIndex]);
    for I := 0 to ValuesNum-1 do begin
      IniValueList[ValIndex,I].Name := '';
      IniValueList[ValIndex,I].Value := '';
    end;
    SetLength(IniValueList[ValIndex],0);
    //     .
    ElementsNum := Length(IniValueList);
    //     -         .
    if ValIndex <> ElementsNum-1 then begin
      Move(IniValueList[ValIndex],DeletingElement,SizeOf(AIniValueListElements));    //    .
      Move(IniValueList[ValIndex+1],IniValueList[ValIndex],SizeOf(AIniValueListElements)*(ElementsNum-(ValIndex+1)));    //   .
      Move(DeletingElement,IniValueList[ElementsNum-1],SizeOf(AIniValueListElements));     //             (   ).
      Move(DummyElement,DeletingElement,SizeOf(AIniValueListElements));     //       -                  (..     )  .
    end;
    //  .
    ElementsNum := ElementsNum-1;
    SetLength(IniValueList,ElementsNum);
  end;
end;

//------------------------------------------//
//            ...             //
//------------------------------------------//

Function TAnIniFile.GoToSection(const SectName : string; TypePos : byte) : boolean;
var
  buf, TestStr : string;
  Finded, TempBool1 : boolean;
  SectLength, I, SectStartCur, TempCur : integer;
begin
  //  -      :)
  
  //     ,   
  //  -  ,   - .
  //      ,    
  //  - .
  result := false;
  Finded := false;
  SectLength := Length(SectName)+2;

  //  -    .
  // - ,   -    :)

  If TextFil1.Siz > 0 then begin
    TextFil1.Cursor := 1;
    repeat
      //  (       ).
      SectStartCur := TextFil1.Cursor;  //     
      buf := TextFil1.CurReadStr;
      //    ...
      If (Length(buf) > 0) and (NotComment(buf) = true) then begin
        // -    
        If buf[1] = '[' then begin
          //  - .
          //  (  ,  )
          If Length(buf) >= SectLength then begin
            //    
            TestStr := '';
            For I := 1 to SectLength do begin
              TestStr := TestStr+buf[I];
            end;

            // -     -.
            If UpperCase('['+SectName+']') = UpperCase(TestStr) then begin
              //  .  .
              Finded := true;
            end;
          end;
        end;
      end;
      If (TextFil1.Cursor <> Length(TextFil1.FileString)+1) and ((Length(TextFil1.FileString)+1)  - (TextFil1.Cursor) >=2)   then begin
        //     ,    2 , ...
        TextFil1.Cursor := TextFil1.Cursor+2;
      end;
    until (Finded = true) or (TextFil1.Eof);

    //  -     , 
    //    (,    
    //).

    If Finded = true then begin
      //    TypePos
      // 1 -    
      // 2 -    
      // 3 -    (    )

      If TypePos = 1 then begin
        //   
        TextFil1.Cursor := SectStartCur;
        Result := true;
      end;

      If TypePos = 2 then begin
        //   
        TextFil1.Cursor := SectStartCur;
        TextFil1.CurReadLn;  //    .
        //     ,  " " -   
        //  .
        if TextFil1.Eof = false then begin
          If TextFil1.FileString[TextFil1.Cursor] <> '[' then begin
            Result := true;
          end
          else begin
            //     ,      :)
            TextFil1.Cursor := SectStartCur;
            TextFil1.CurReadStr;       //   - 
            TextFil1.InsertString(TextFil1.Cursor,#13#10);
            TextFil1.Cursor := TextFil1.Cursor+2;
          end;
        end;
      end;

      If TypePos = 3 then begin
        //   
        TextFil1.Cursor := SectStartCur;
        TempCur := TextFil1.Cursor;
        //TextFil1.CurReadLn;   //    .
        //       .
        repeat
          TempBool1 := false;
          //TempCur := SectStartCur;  //   -  
                                    // 
          If TextFil1.Eof <> true then begin
            TempCur := TextFil1.Cursor;  //  "" 
            TextFil1.CurReadLn;  //  . .
            buf := TextFil1.ReadStrLn(TextFil1.Cursor);   // 1  ...
            If Length(buf) > 0 then begin
              // -    .
              //..    ,     
              //. (      ).
              If buf[1] = '[' then begin
                TempBool1 := true; //  
                //TempCur :=
              end;
            end;
          end;
        until  (TempBool1 = true) or (TextFil1.Eof = true);

        //,     ""
        If TextFil1.Eof = true then begin
          //,       .
          if TextFil1.FileString[TextFil1.Cursor-1] = #10 then begin
            //,  .
            result := true;
          end
          else begin
            //     .
            //  1 .
            TextFil1.FileString := TextFil1.FileString+#13+#10;
            TextFil1.Cursor := TextFil1.Cursor+2;
            result := true;
          end;
        end
        else begin
          //     .
          TextFil1.Cursor := TempCur;  //   ,     
          buf := TextFil1.CurReadStr;  //    +  .

          //  -    .
          // ,  ,     1  .
          //  -     .
          If Length(buf) > 0 then begin
            // ""  1    .
            TextFil1.InsertString(TextFil1.Cursor,#13+#10);
            TextFil1.Cursor := TextFil1.Cursor+2;  // .
            result := true;
          end
          else begin
            // ,     .      :)
            result := true;   //    ...
          end;

        end;

      end;
    end;

  end
  else begin
    //,  - .
    //     ,     .
  end;  
end;

Function TAnIniFile.GoToElement(const SectName, ElemName : string) : boolean;
var
  Finished : boolean;
  TempCur, TempPos : Longint;
  Buf : string;
begin
  //    .

  // ...
  Finished := false;
  Result := false;
  TempCur := TextFil1.Cursor;  //    , 
  //   .

  //    
  If GoToSection(SectName,2) = true then begin
    // ,    .
    repeat
      If TextFil1.Eof = false then begin
        TempPos := TextFil1.Cursor;  //,    .
        buf := TextFil1.CurReadLn;
        if length(buf) > 0 then begin
          //    .
          If buf[1] <> '[' then begin
            //    .   :)
            If GetElemName(Buf) = ElemName then begin
              //  ,   :)
              TextFil1.Cursor := TempPos;  //     
              Result := true;
              Finished := true;  //   .
            end;
          end
          else begin
            // ,    .  .
            Finished := true;
          end;
        end;
      end
      else begin
        //  ,   .
        Finished := true;
      end;
    until Finished = true;
  end;

  If Result = false then begin
    //     .
    TextFil1.Cursor := TempCur;
  end;
  
end;

Function TAnIniFile.NotComment(const Str : string) : boolean;
// -    
begin
  //  .      ,   - false,   - true.
  
  Result := true;  //   -  .
  
  if Length(Str) = 0 then begin
    Result := false;   //   -   .
  end
  else if Length(Str) > 0 then begin
    //  ...
    if Str[1] = ';' then begin
      Result := false;
    end
    else if Str[1] = '#' then begin
      Result := false;
    end
    else if Length(Str) > 1 then begin
      // ...
      if Str[1]+Str[2] = '//' then begin
        Result := false;
      end;
    end;
  end;
end;

Function TAnIniFile.GetElemName(const Str : string) : string;
var
  TempStr : string;
begin
  //-   (,    ).
  //   ,   ,  ,
  //..      ,  
  //   ,     .

  Result := '';  //    .
  If NotComment(Str) = true then begin
    //    .
    //   -    :)

    TempStr := Str;
    Result := Parse(TempStr,'=');
  end;
end;

Function TAnIniFile.GetElemStr(const Str : string) : string;
var
  TempStr : string;
begin
  //-   (  ).
  //       ,
  //      (   ).

  TempStr := Str;
  Parse(TempStr,'=');
  Result := TempStr;
end;



end.
