///////////////////////////////////////////////////////////
//                   VerInfoTxtFormat                    //
//              VerInfoTxt        //
//                .         //
//                                                       //
//           Copyright (C) 2007-2010 Gipat Group         //
//                                                       //
//                             //
//                  Modified LGPL v2.1                   //
//           .  COPYING.modifiedLGPL.txt           //
//                                                       //
//                    0.1                    //
//                                                       //
//                   sagrer@yandex.ru                    //
///////////////////////////////////////////////////////////

//      , ....  :
// 1)  (Sagrer)  (sagrer@yandex.ru)

////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////
//                - 1                //
////////////////////////////////////////////////////

unit VerInfoTxtFormat;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LCLTextFileInString, ExtraFunctionsLcl, TranslManager;
  
const
  VIT_FormatVersion = 1;                //     .
  // :
  VIT_Status_Unknown = -1;              // 
  VIT_Status_Alpha = 0;                 //.
  VIT_Status_Beta = 1;                  //.
  VIT_Status_ReleaseCandidate = 3;      //-.
  VIT_Status_Release = 4;               //.

type

  TVerInfoTxtFormat = class            //      VerInfoTxt (*.vit).
  private
    //
    VerNum : Integer;                  //   ...
    // ...
    procedure ParseVerNum(Buff : AnsiString);    //      Buff
    procedure ParseStatus(Buff : AnsiString);    //     Buff
  public
    //
    Ver1 : Integer;                    // 1  ...
    Ver2 : Integer;                    // 2  ...
    Ver3 : Integer;                    // 3  ...
    Ver4 : Integer;                    // 4  ...
    Status : Integer;                  // ...
    RCNum : Integer;                   // -   -.
    ErrorMessage : AnsiString;         //    .
    
    //-...
    constructor Create;
    destructor Destroy; override;
    
    // ...
    procedure Clear();                                       //      .
    function Load(const FileName : AnsiString) : boolean;    //   .
    function Save(const FileName : AnsiString) : boolean;    //     .
    function GenerateStatusString(const FullMode : boolean = false; const InFileFormat : boolean = false) : AnsiString;            //    .
    function GenerateVersionString() : AnsiString;             //         about.
    function GenerateVersionString_nosvn() : AnsiString;       //         about.    .
    function GenerateFNVersionString_nostatus() : AnsiString;  //         ,   .
    function GenerateFNVersionString() : AnsiString;           //         .
    function GenerateShortVersionString() : AnsiString;        //          .
    function GenerateShortVersionString_nosvn() : AnsiString;  //          .    .
    function GenerateDotsVersionString() : AnsiString;         //    ,      .
    function ReadFromStringEx(const VerString : AnsiString; const Separator : AnsiString) : Boolean;    //    VerString       .       GenerateShortVersionString_nosvn       .
    function ReadFromString(const VerString : AnsiString) : Boolean;   //    VerString       .      GenerateShortVersionString_nosvn.
    function ReadFromFNString(const VerFNString : AnsiString) : Boolean;   //    VerString       .      GenerateFNVersionString.
    function IsSameVersion(var AnotherVit : TVerInfoTxtFormat) : Boolean;  // .   -  true,  false.
    function IIsNewerThenOldVit(var OldVit : TVerInfoTxtFormat) : Boolean;   //    vit -       -  true  false.
  end;

implementation

/////////////////////////////////////////////
//           TVerInfoTxtFormat             //
/////////////////////////////////////////////

//-----------------------------------------//
//        -...      //
//-----------------------------------------//

constructor TVerInfoTxtFormat.Create;
begin
  //  ...
  Self.Clear();
  ErrorMessage := 'none';

  //   ...
   
end;

destructor TVerInfoTxtFormat.Destroy;
begin
  // 

  //  
  inherited;
end;

//------------------------------------------//
//            ...             //
//------------------------------------------//

procedure TVerInfoTxtFormat.ParseVerNum(Buff : AnsiString);
//      Buff
begin
  Parse(Buff, ' ');
  VerNum := StrToInt(Trim(Buff));
end;

procedure TVerInfoTxtFormat.ParseStatus(Buff : AnsiString);
//     Buff
begin
  if Buff = 'a' then begin
    // - .
    Self.Status := VIT_Status_Alpha;
  end
  else if Buff = 'b' then begin
    // - .
    Self.Status := VIT_Status_Beta;
  end
  else if (Buff = 'r') or (Length(Buff)=0) then begin
    // - .
    Self.Status := VIT_Status_Release;
  end
  else if Length(Buff) > 1 then begin
    //  .         -.

    // - -.
    Self.Status := VIT_Status_ReleaseCandidate;
    //  .
    Self.RCNum := StrToInt(RightStr(Buff,Length(Buff)-2));
  end;
end;

//------------------------------------------//
//            ...             //
//------------------------------------------//

procedure TVerInfoTxtFormat.Clear();
//      .
begin
  //  ...
  VerNum := -1;
  Ver1 := -1;
  Ver2 := -1;
  Ver3 := -1;
  Ver4 := -1;
  Status := VIT_Status_Unknown;
  RCNum := -1;
end;

function TVerInfoTxtFormat.Load(const FileName : AnsiString) : boolean;
//   .
var
  FileStr1 : TTextFileInString;
  AllOk : boolean;
  
begin
  //.
  FileStr1 := TTextFileInString.Create;
  Result := false;
  
  // ...
  
  AllOk := FileExists(FileName);
  if AllOk = false then begin
    //   ...
    ErrorMessage := _('File ')+FileName+_(' is not exists.');
  end
  else begin
    //    ... ...
    AllOk := FileStr1.Load(FileName);
    if AllOk = false then begin
      //   .
      ErrorMessage := _('Error, loading file ')+FileName;
    end;
  end;
  
  if AllOk = true then begin
    //, .  ...
    if FileStr1.CurReadLn() <> 'VerInfoTxt' then begin
      //  VerInfoTxt-.
      AllOk := false;
      ErrorMessage := _('File ')+FileName+_(' is not VerInfoTxt file.');
    end;
  end;
  
  if AllOk = true then begin
    //  ...
    ParseVerNum(Trim(FileStr1.CurReadLn()));
    if Self.VerNum > VIT_FormatVersion then begin
      //       .
      AllOk := false;
      ErrorMessage := _('File ')+FileName+_(' has more new version (')+IntToStr(Self.VerNum)+_(') then i know (')+IntToStr(VIT_FormatVersion)+_('). Aborted loading. Try update to a new version of this software.');
    end;
  end;
  
  if AllOk = true then begin
    //  ...
    //      -     .
    
    //Ver
    Ver1 := StrToInt(Trim(FileStr1.CurReadLn()));
    Ver2 := StrToInt(Trim(FileStr1.CurReadLn()));
    Ver3 := StrToInt(Trim(FileStr1.CurReadLn()));
    Ver4 := StrToInt(Trim(FileStr1.CurReadLn()));
    //Status
    ParseStatus(Trim(FileStr1.CurReadLn()));
    
    //,      .       .
    Result := true;
  end;
  
  // .
  FileStr1.Free;
end;

function TVerInfoTxtFormat.Save(const FileName : AnsiString) : boolean;
//     .
var
  FileStr1 : TTextFileInString;
begin
  //  .          ...
  
  //
  FileStr1 := TTextFileInString.Create;
  Result := false;
  
  //    .
  FileStr1.MakNewFile;
  FileStr1.AddStr('VerInfoTxt');    //
  FileStr1.AddStr('v '+IntToStr(VIT_FormatVersion));     // 
  FileStr1.AddStr(IntToStr(Ver1));        // ...
  FileStr1.AddStr(IntToStr(Ver2));        //--""--
  FileStr1.AddStr(IntToStr(Ver3));        //--""--
  FileStr1.AddStr(IntToStr(Ver4));        //--""--
  FileStr1.AddStr(GenerateStatusString(false,true));   //
  //    .
  FileStr1.Save(FileName);
  //   -   -    ,    %).
  //        ,    ,   
  //    -          ,  
  //   ,    ,  GUI,   ....
  Result := true;
  
  // 
  FileStr1.Free;
end;

function TVerInfoTxtFormat.GenerateStatusString(const FullMode : boolean = false; const InFileFormat : boolean = false) : AnsiString;
//    .
begin
  // .
  Result := '';
  
  //        .
  if Status = VIT_Status_Alpha then begin
    //.
    if FullMode = false then begin
      //
      Result := 'a';
    end
    else begin
      //
      Result := ' Alpha';
    end;
  end
  else if Status = VIT_Status_Beta then begin
    //.
    if FullMode = false then begin
      //
      Result := 'b';
    end
    else begin
      //
      Result := ' Beta';
    end;
  end else if Status = VIT_Status_Release then begin
    // -   .
    Result := '';
  end else if Status = VIT_Status_ReleaseCandidate then begin
    //-.    -      RC    - .
    if FullMode = false then begin
      //
      if InFileFormat = true then begin
        //  -       VerInfoTxt.
        Result := 'rc'+IntToStr(RCNum);
      end else begin
        //  -     .
        Result := ' RC'+IntToStr(RCNum);
      end;
    end
    else begin
      //
      Result := ' Release Candidate N '+IntToStr(RCNum);
    end;
  end else if Status = VIT_Status_Unknown then begin
    // .     ,   ...
    //   ,       .
    //             
    //   VIT_Status_Unknown.
    //        - ,   - .
    Result := '';
  end;
end;

function TVerInfoTxtFormat.GenerateVersionString() : AnsiString;
//         about.
begin
  //   ...
  Result := IntToStr(Ver1)+'.'+IntToStr(Ver2)+'.'+IntToStr(Ver3);
  // ...
  Result := Result+GenerateStatusString(true);
  // .
  Result := Result+', revision: '+IntToStr(Ver4);
end;

function TVerInfoTxtFormat.GenerateVersionString_nosvn() : AnsiString;
//         about.    .
begin
  //   ...
  Result := IntToStr(Ver1)+'.'+IntToStr(Ver2)+'.'+IntToStr(Ver3)+'.'+IntToStr(Ver4);
  // ...
  Result := Result+GenerateStatusString(true);
end;

function TVerInfoTxtFormat.GenerateFNVersionString_nostatus() : AnsiString;
//         ,   .
begin
  //   ...
  Result := IntToStr(Ver1)+'_'+IntToStr(Ver2)+'_'+IntToStr(Ver3)+'_'+IntToStr(Ver4);
end;

function TVerInfoTxtFormat.GenerateFNVersionString() : AnsiString;
//         .
begin
  //   ...
  Result := Self.GenerateFNVersionString_nostatus();
  // ...
  Result := Result+GenerateStatusString(false,true);
end;

function TVerInfoTxtFormat.GenerateShortVersionString() : AnsiString;
//          .
begin
  //   ...
  Result := IntToStr(Ver1)+'.'+IntToStr(Ver2)+'.'+IntToStr(Ver3);
  // ...
  Result := Result+GenerateStatusString(false,true);
  // .
  Result := Result+', r'+IntToStr(Ver4);
end;

function TVerInfoTxtFormat.GenerateShortVersionString_nosvn() : AnsiString;
//          .    .
begin
  //   ...
  Result := IntToStr(Ver1)+'.'+IntToStr(Ver2)+'.'+IntToStr(Ver3)+'.'+IntToStr(Ver4);
  // ...
  Result := Result+GenerateStatusString(false,true);
end;

function TVerInfoTxtFormat.GenerateDotsVersionString() : AnsiString;
//    ,      .
begin
  //   ...
  Result := IntToStr(Ver1)+'.'+IntToStr(Ver2)+'.'+IntToStr(Ver3)+'.'+IntToStr(Ver4);
end;

function TVerInfoTxtFormat.ReadFromStringEx(const VerString : AnsiString; const Separator : AnsiString) : Boolean;
//    VerString       .
//      GenerateShortVersionString_nosvn
//      .
var
  TempVerStr, TempParsedStr : AnsiString;

begin
  //.
  Result := true;
  Self.Clear();

  //, .
  TempVerStr := VerString;
  //1
  if Length (TempVerStr) > 0 then begin
    TempParsedStr := Parse(TempVerStr,Separator);
  end
  else Result := false;     //..  .
  if (IsNumericStr(TempParsedStr) = true) and (Result = true) then begin
    Self.Ver1 := StrToInt(TempParsedStr);
  end
  else Result := false;

  //2
  if (Length (TempVerStr) > 0) and (Result = true) then begin
    TempParsedStr := Parse(TempVerStr,Separator);
  end
  else Result := false;
  if (IsNumericStr(TempParsedStr) = true) and (Result = true) then begin
    Self.Ver2 := StrToInt(TempParsedStr);
  end
  else Result := false;

  //3
  if (Length (TempVerStr) > 0) and (Result = true) then begin
    TempParsedStr := Parse(TempVerStr,Separator);
  end
  else Result := false;
  if (IsNumericStr(TempParsedStr) = true) and (Result = true) then begin
    Self.Ver3 := StrToInt(TempParsedStr);
  end
  else Result := false;

  //4
  if (Length (TempVerStr) > 0) and (Result = true) then begin
    //     ""  .
    TempParsedStr := ParseNumericHead(TempVerStr);
  end
  else Result := false;
  if (IsNumericStr(TempParsedStr) = true) and (Result = true) then begin
    Self.Ver4 := StrToInt(TempParsedStr);
  end
  else Result := false;

  //.
  if Result = true then begin
    //  .
    Self.ParseStatus(TempVerStr);
    //        -    .   -  -         .
    Parse(TempVerStr,Separator);
  end;
  
  if (Length (TempVerStr) > 0) and (Result = true) then begin
    //    . .
    Result := false;
  end;

  if Result = false then begin
    Self.ErrorMessage := _('VIT: incorrect version format.');
  end;
end;

function TVerInfoTxtFormat.ReadFromString(const VerString : AnsiString) : Boolean;
//    VerString       .
//     GenerateShortVersionString_nosvn.
begin
  Result := Self.ReadFromStringEx(VerString,'.');
end;

function TVerInfoTxtFormat.ReadFromFNString(const VerFNString : AnsiString) : Boolean;
//    VerString       .
//     GenerateFNVersionString.
begin
  Result := Self.ReadFromStringEx(VerFNString,'_');
end;

function TVerInfoTxtFormat.IsSameVersion(var AnotherVit : TVerInfoTxtFormat) : Boolean;
// .   -  true,  false.
begin
  //.
  Result := false;
  
  if (Self.Ver1 = AnotherVit.Ver1) and
     (Self.Ver2 = AnotherVit.Ver2) and
     (Self.Ver3 = AnotherVit.Ver3) and
     (Self.Ver4 = AnotherVit.Ver4) and
     (Self.Status = AnotherVit.Status) then begin
    //,  .
    if (Self.Status = VIT_Status_ReleaseCandidate) and (AnotherVit.Status = VIT_Status_ReleaseCandidate) then begin
      //   -.
      if Self.RCNum = AnotherVit.RCNum then begin
        // .
        Result := true;
      end;
    end
    else begin
      // .
      Result := true;
    end;
  end;
end;

function TVerInfoTxtFormat.IIsNewerThenOldVit(var OldVit : TVerInfoTxtFormat) : Boolean;
//    vit -       -  true  false.
var
  IsAbsoluteNewer : Boolean;
  
begin
  //.
  Result := true;
  IsAbsoluteNewer := false;   // true           -     .
  
  //.
  if Self.Ver1 < OldVit.Ver1 then begin
    //   .
    Result := false;
  end
  else if Self.Ver1 > OldVit.Ver1 then begin
    //     -    .
    IsAbsoluteNewer := true;
  end;
  
  if ( (Result = true) and (IsAbsoluteNewer = false) ) then begin
    //   .
    if Self.Ver2 < OldVit.Ver2 then begin
      Result := false;
    end
    else if Self.Ver2 > OldVit.Ver2 then begin
      //     -    .
      IsAbsoluteNewer := true;
    end;
  end;
  
  if ( (Result = true) and (IsAbsoluteNewer = false) ) then begin
    //   .
    if Self.Ver3 < OldVit.Ver3 then begin
      Result := false;
    end
    else if Self.Ver3 > OldVit.Ver3 then begin
      //     -    .
      IsAbsoluteNewer := true;
    end;
  end;
  
  if ( (Result = true) and (IsAbsoluteNewer = false) ) then begin
    //   .
    if Self.Ver4 < OldVit.Ver4 then begin
      Result := false;
    end
    else if Self.Ver4 > OldVit.Ver4 then begin
      //     -    .
      IsAbsoluteNewer := true;
    end;
  end;
  
  if (Result = true) and (Self.Ver1 = OldVit.Ver1) and (Self.Ver2 = OldVit.Ver2) and (Self.Ver3 = OldVit.Ver3) and (Self.Ver4 = OldVit.Ver4) then begin
    //   -   ...
    if Self.Status < OldVit.Status then begin
      Result := false;
    end
    else begin
      //  -.
      if (Self.Status = VIT_Status_ReleaseCandidate) and (OldVit.Status = VIT_Status_ReleaseCandidate) then begin
        //  .
        if Self.RCNum < OldVit.RCNum then begin
          Result := false;
        end;
      end;
    end;
  end;
  
  if Result = true then begin
    // -     ?
    if Self.IsSameVersion(OldVit) = true then begin
      // -     .
      Result := false;
    end;
  end;
  
end;

end.

