///////////////////////////////////////////////////////////
//                    ao_craft_calc                      //
//          Калькулятор крафта для Аллодов Онлайн        //
//               Copyright (C) 2014 Sagrer               //
//             Распространяется на условиях              //
//                  Modified LGPL v2.1                   //
//           см. файл COPYING.modifiedLGPL.txt           //
//                                                       //
//    http://personal.sagrer.ru/tracs/ao_craft_calc      //
///////////////////////////////////////////////////////////

//Please, use UTF8-encoding to read this file.
//Chtobi prochitat etot fail - vospolzuites kodirovkoy UTF8.

//Над данным файлом работали:
// 1) Sagrer (sagrer@yandex.ru)
// 2)

////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////
//                   Окно "о программе"                      //
///////////////////////////////////////////////////////////////

unit AboutForm;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls;

type

  { TAboutF }

  TAboutF = class(TForm)
    AppNameLab: TLabel;
    LicenseBut: TButton;
    CloseBut: TButton;
    DescrLab: TLabel;
    CopyrightLab: TLabel;
    UsedLibsMemo: TMemo;
    VerLab: TLabel;
    VerCaptLab: TLabel;
    procedure CloseButClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LicenseButClick(Sender: TObject);
  private
    { private declarations }
    FirstShowed : boolean;       //Индикатор - было ли уже OnShow?
  public
    { public declarations }
  end; 

var
  AboutF: TAboutF;

implementation

uses
  GlobalJunkYard, MainForm, UTF8Process;

{ TAboutF }

procedure TAboutF.CloseButClick(Sender: TObject);
begin
  //Просто закрыть окно - никаких извращенств тут не требуется.
  Self.Close;
end;

procedure TAboutF.FormCreate(Sender: TObject);
begin
  //При создании окна - отметить что оно ещё не отображалось.
  FirstShowed := false;
end;

procedure TAboutF.FormShow(Sender: TObject);
begin
  If FirstShowed = false then begin
    //Действия при первой прорисовке...
    FirstShowed := true;

    //Отобразить на форме инфу о версии...
    AppNameLab.Caption := AOC_AppName;
    DescrLab.Caption := AOC_Description;
    VerLab.Caption := MainF.AppLogic.AppVersion.GenerateVersionString;
    CopyrightLab.Caption := AOC_CopyrightStr;
    //CraftedByLab.Caption := CraftedBy_list;
    //DevelsContactsLab.Caption := DevelsContacts;
  end;
end;

procedure TAboutF.LicenseButClick(Sender: TObject);
var
  NotepadProcess: TProcessUTF8;
begin
  //Пользователь тыкнул по кнопке просмотра лиц-соглашения.
  NotepadProcess := TProcessUTF8.Create(nil);
  try
    NotepadProcess.CommandLine:='notepad.exe '+MainF.AppLogic.AppPath+'License.txt';
    NotepadProcess.Execute;
  finally
    NotepadProcess.Free;
  end;
end;

initialization
  {$I AboutForm.lrs}

end.

