///////////////////////////////////////////////////////////
//                    ao_craft_calc                      //
//          Калькулятор крафта для Аллодов Онлайн        //
//               Copyright (C) 2014 Sagrer               //
//             Распространяется на условиях              //
//                  Modified LGPL v2.1                   //
//           см. файл COPYING.modifiedLGPL.txt           //
//                                                       //
//    http://personal.sagrer.ru/tracs/ao_craft_calc      //
///////////////////////////////////////////////////////////

//Please, use UTF8-encoding to read this file.
//Chtobi prochitat etot fail - vospolzuites kodirovkoy UTF8.

//Над данным файлом работали:
// 1) Sagrer (sagrer@yandex.ru)
// 2)

////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////
//               Служебный класс для логики                  //
//             и глобальных данных приложения.               //
///////////////////////////////////////////////////////////////

unit AOC_LogicClass;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, VerInfoTxtFormat, AOC_Settings, AOC_CraftCalcEngine;

type
  TAOC_LogicClass = class       //Класс логики приложения
  private
  protected
  public
    //Простые переменные
    AppPath : AnsiString;       //Путь к директории с приложением.
    ConfigsPath : AnsiString;    //Путь к конфигам.
    AppInitialized : boolean;             //Выполнялась ли инициализация.

    //Вложенные переменные-объекты
    AppVersion : TVerInfoTxtFormat;        //Информация о версии.
    AppSettings : TAOC_Settings;           //Менеджер настроек.
    CraftCalcEngine : TCraftCalcEngine;    //Собсно калькулятор крафта.

    //Конструкторы-деструкторы...
    constructor Create; virtual;
    destructor Destroy; override;

    //Открытые методы...
    function InitApp : boolean;                      //Метод, инициализующий приложение - найти и подгрузить настройки итд.

  end;

implementation

uses ExtraFileUtilsLCL, Forms, LCLType, GlobalJunkYard;

/////////////////////////////////////////////
//              TAOC_LogicClass            //
/////////////////////////////////////////////

//-----------------------------------------//
//        Конструкторы-деструкторы...      //
//-----------------------------------------//

constructor TAOC_LogicClass.Create;
begin
  //Создать вложенные объекты классов...
  AppVersion := TVerInfoTxtFormat.Create;
  AppSettings := TAOC_Settings.Create;
  CraftCalcEngine := TCraftCalcEngine.Create;

  //Проставить дефолтные значения...
  AppInitialized := false;

  //Просто забить инфу в переменные...
  AppPath := AddLastSlash(ExtractFilePath( Application.ExeName ));   //Путь к программе.
  //AppVersion.Ver1 := AOC_Ver1;      //Инфа о версии.
  //AppVersion.Ver2 := AOC_Ver2;      //--""--
  //AppVersion.Ver3 := AOC_Ver3;      //--""--
  //AppVersion.Ver4 := AOC_Ver4;      //--""--
  //AppVersion.Status := AOC_Status;  //--""--
  //AppVersion.RCNum := AOC_RCNum;    //--""--
  AppVersion.Ver1 := 0;      //Жёстко вписанная в исходник инфа о версии, мне влом пока привязывать сборочную систему ).
  AppVersion.Ver2 := 1;      //--""--
  AppVersion.Ver3 := 0;      //--""--
  AppVersion.Ver4 := 40;      //--""--
  AppVersion.Status := VIT_Status_Alpha;  //--""--
  AppVersion.RCNum := 0;    //--""--
end;

destructor TAOC_LogicClass.Destroy;
begin
  //Выкидываем мусор
  AppVersion.Free;
  AppSettings.Free;
  CraftCalcEngine.Free;

  //Выполнить унаследованный деструктор
  inherited;
end;

//------------------------------------------//
//           Защищенные методы...           //
//------------------------------------------//

//------------------------------------------//
//            Открытые методы...            //
//------------------------------------------//

function TAOC_LogicClass.InitApp : boolean;
//Метод, инициализующий приложение - найти и подгрузить настройки итд.
//Метод типовой, скопипащенный из какого-то прошлого проекта так что часть ненужного
//на данный момент функционала закомментирована, может быть ещё и пригодится когда-нибудь.
var
  ConfigsFinded, AllOk : Boolean;
  //FLMaster : TFirstLaunchMaster;           //Теоретически в программе может быть некий мастер первого запуска, он нам пока особо не нужен.

begin
  //Итак, для начала поищем где у нас конфиги по идее должны лежать.
  ConfigsFinded := false;
  AllOk := true;
  //ConfigsPath := AddLastSlash(GetUserDir)+'Application Data\'+AOC_ConfigsDirName+'\';
  ConfigsPath := Self.AppPath+'configs\';
  //if DirectoryExists(ConfigsPath) = false then begin
    //Нету каталога с конфигами по стандартному месту - проверим каталог программы.
    if DirectoryExists(Self.AppPath+'configs\') = true then begin
      //Проверим есть ли там собсно файл конфига.
      if FileExists(Self.AppPath+'configs\'+AOC_ConfigFileName) = true then begin
        //Есть такое дело. Спросим пользователя чего делать.
        //if Application.MessageBox('Не удалось обнаружить настройки программы в стандартном месте, '+
        //   'однако имеется набор настроек в директории программы. Использовать данный набор?','SupportI',MB_YESNO or MB_ICONQUESTION) = IDYES then
        //begin
          //Пользователь согласился использовать настройки в папке программы.
          ConfigsFinded := true;
          ////Поставить отметку о том что используются конфиги в папке программы.
          //if ForceDirectories(ConfigsPath) = true then begin
          //  FileClose(FileCreate(ConfigsPath+'ConfigsAreInAppDir'));
          //end
          //else begin
          //  //По какой-то причине у программы нет доступа на запись в домашний каталог
          //  //пользователя. Прекращаем работу.
          //  Application.MessageBox(PChar('Не удалось получить доступ к директории '+ConfigsPath+' с настройками.'),'Ошибка',MB_OK or MB_ICONERROR);
          //  AllOk := false;
          //end;
        //end;
      end;
    end;
  //end
  //else begin
  //  //Директория с конфигами найдена.
  //  ConfigsFinded := true;
  //end;

  if (ConfigsFinded = true) and (AllOk = true) then begin
    //Есть каталог с конфигами. Проверяем, нет ли там отметки что настоящий каталог он в директории программы.
    //Хотя вообще ложить конфиги в папку куда программа ставилась нехорошо, если
    //это окажется где-то внутри Program Files - то Windows версий старше XP этого
    //очень не любит, пускай иногда и пытается чего-то там эмулировать, иногда
    //даже успешно.
    if FileExists(ConfigsPath+'ConfigsAreInAppDir') = true then begin
      //Меняем путь конфигов.
      ConfigsPath := Self.AppPath+'configs\';
    end;

    //Проверяем, существует ли главный файл конфига.
    if FileExists(ConfigsPath+AOC_ConfigFileName) = false then begin
      //Нету.
      ConfigsFinded := false;
      AllOk := false;
    end;
  end;

  {if (ConfigsFinded = false) and (AllOk = true) then begin
    //Если на данном этапе нормальные конфиги не обнаружены - воспринимаем это
    //как первый запуск. Вызываем мастер первого запуска.
    FLMaster := TClientFirstLaunchMaster.Create(ConfigsPath);

    //Вбиваем настройки по умолчанию...
    //Ну, пока что их нету %).

    //Запускаем мастер.
    AllOk := FLMaster.LaunchMaster;

    //По идее, если мастер нормально отработал - должен быть создан работоспособный каталог с конфигами.
    ConfigsFinded := AllOk;

    //Уборка мусора.
    FLMaster.Free;
  end;}

  if AllOk = true then begin
    //Читаем конфиги.
    AllOk := Self.AppSettings.LoadFromFile(ConfigsPath+AOC_ConfigFileName);
    ////Для тестирования пишем конфиг.
    //AllOk := Self.AppSettings.SaveToFile(ConfigsPath+'test.ini');
  end;

  //Если при загрузке конфига были ошибки - оно само уже ругалось. Просто аварийно завершаем работу (из функции вернётся false).

  if AllOk = true then begin
    //Если же конфиги подгрузились нормально - делаем то чего там надо делать %).
    //Пока что ничего не надо ))
  end;

  //Если всё в порядке...
  if AllOk = true then begin
    //Ставим отметку что инициализация выполнена.
    AppInitialized := true;
  end;

  //Вернуть результат.
  Result := AllOk;
end;

end.

