///////////////////////////////////////////////////////////
//                    ao_craft_calc                      //
//          Калькулятор крафта для Аллодов Онлайн        //
//               Copyright (C) 2014 Sagrer               //
//             Распространяется на условиях              //
//                  Modified LGPL v2.1                   //
//           см. файл COPYING.modifiedLGPL.txt           //
//                                                       //
//    http://personal.sagrer.ru/tracs/ao_craft_calc      //
///////////////////////////////////////////////////////////

//Please, use UTF8-encoding to read this file.
//Chtobi prochitat etot fail - vospolzuites kodirovkoy UTF8.

//Над данным файлом работали:
// 1) Sagrer (sagrer@yandex.ru)
// 2)

////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
//       Класс объекта для хранения одной строчки результатов подбора крафта     //
///////////////////////////////////////////////////////////////////////////////////

unit AOC_CraftCalcResult;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

type
  ALongInts = array of LongInt;        //Массив LongInt
  ALongInts2D = array of ALongInts;    //Двумерный массив LongInt

  TCraftCalcResult = class
  private
    //Внутренние переменные
    //Закрытые методы
  protected
  public
    //Переменные
    RegsCount : ALongInts;    //Массив под инфу о количестве реагентов.
    ItemsNum : LongWord;       //Сколько потребуется улучшителей.
    LostPower : Double;        //Сколько процентов крафта получилось лишних.
    CraftCost : LongWord;      //Сколько денег потребуется на улучшение.
    IsBadResult : Boolean;     //Признак того что вариант неудачен и есть что-то получше.
    //Вложенные объекты

    //Конструкторы-деструкторы
    constructor Create; virtual;
    destructor Destroy; override;

    //Открытые методы
    //Свойства
  end;

  ACraftCalcResults = array of TCraftCalcResult;   //Тип массива для списка результатов.


implementation

/////////////////////////////////////////////
//            TCraftCalcResult
/////////////////////////////////////////////

//-----------------------------------------//
//        Конструкторы-деструкторы...      //
//-----------------------------------------//

constructor TCraftCalcResult.Create;
begin
  //Создать вложенные объекты классов...

  //Массив изначально пустой.
  SetLength(RegsCount,0);

  //Проставить дефолтные значения...
  ItemsNum := 0;
  LostPower := 0;
  CraftCost := 0;
  IsBadResult := false;

  //Просто забить инфу в переменные...

end;

destructor TCraftCalcResult.Destroy;
begin
  //Выкидываем мусор
  SetLength(RegsCount,0);

  //Выполнить унаследованный деструктор
  inherited;
end;

//------------------------------------------//
//            Закрытые методы...            //
//------------------------------------------//

//------------------------------------------//
//           Защищенные методы...           //
//------------------------------------------//

//------------------------------------------//
//            Открытые методы...            //
//------------------------------------------//

end.

