///////////////////////////////////////////////////////////
//                    TranslManager                      //
//                      //
//         ,   ,     //
//                  *.mo-.              //
//                  _().         //
//                                                       //
//                                                       //
//             Copyright (C) 2008-2010 Sagrer            //
//                                                       //
//                             //
//                  Modified LGPL v2.1                   //
//           .  COPYING.modifiedLGPL.txt           //
//                                                       //
//                    0.1                    //
//                                                       //
//                   sagrer@yandex.ru                    //
///////////////////////////////////////////////////////////

//      , ....  :
// 1)  (Sagrer)  (sagrer@yandex.ru)

////////////////////////////////////////////////////////////////////////

unit TranslManager;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, forms, MOExtractor;
  
type
  TTranslManager = class        //,   ,   *.mo-.
  private
    // .
    UseTransl : boolean;               //  .
    TranslMODir : AnsiString;          //    .
    TranslMOPrefix : AnsiString;       //   .
    TranslUseLang : AnsiString;        // .
  protected
    // .
    // .
  public
    //
    Transl : TMOExtractor;             //    .

    //-...
    constructor Create; virtual;
    destructor Destroy; override;

    // ...
    procedure DisableLanguage;    virtual;                                  //  .
    procedure SetMODir(const MODir : AnsiString);                           //   .
    procedure SetMOPrefix(const MOPrefix : AnsiString);                     //    .
    function EnableLanguageDefault : Boolean;   virtual;                    //     .     false.
    function EnableLanguage(const Lang : AnsiString) : Boolean;  virtual;   //    .     false.
    function IsLanguageEnabled : Boolean; virtual;                          //  ,   .
    function GetCurrLanguage : AnsiString; virtual;                         //     ,    -  none.
  end;
  
var
  TranslMan : TTranslManager;    //     .
  
// .
function _(AOrig: String) : String;     //-  TranslMan.Transl._(AOrig);   .

implementation

/////////////////////////////////////////////
//              TTranslManager             //
/////////////////////////////////////////////

//-----------------------------------------//
//        -...      //
//-----------------------------------------//

constructor TTranslManager.Create;
begin
  //  ...
  //
  UseTransl := false;
  TranslMODir := ExtractFilePath(Application.ExeName)+'Languages';
  TranslMOPrefix := '';
  TranslUseLang := 'none';
  //

  //
  

  //   ...
  Transl := TMOExtractor.CreateAsDummy();
end;

destructor TTranslManager.Destroy;
begin
  // 
  Transl.Free;

  //  
  inherited;
end;

//------------------------------------------//
//              ...             //
//------------------------------------------//

procedure TTranslManager.DisableLanguage;
//  .
begin
  //   ,     "".
  Self.Transl.Free;
  Self.Transl := TMOExtractor.CreateAsDummy;
  Self.UseTransl := false;
  Self.TranslUseLang := 'none';
end;

procedure TTranslManager.SetMODir(const MODir : AnsiString);
//   .
begin
  Self.TranslMODir := MODir;
end;

procedure TTranslManager.SetMOPrefix(const MOPrefix : AnsiString);
//    .
begin
  Self.TranslMOPrefix := MOPrefix;
end;

function TTranslManager.EnableLanguageDefault : Boolean;
//     .     false.
begin
  //    .
  Result := Self.EnableLanguage('default');
end;

function TTranslManager.EnableLanguage(const Lang : AnsiString) : Boolean;
//    .     false.
begin
  //.
  Result := false;
  //    ...
  Self.Transl.Free;
  //   ,    ,  .
  Self.Transl := TMOExtractor.Create(Self.TranslMODir, Self.TranslMOPrefix, Lang);
  //,     .
  if Self.Transl.LangConnected = true then begin
    //   -   .
    Self.UseTransl := true;
    Self.TranslUseLang := Self.Transl.GetCurrLang;
    Result := true;   //   .
  end
  else begin
    //.  ...
    Self.DisableLanguage;
    //  false   -   false  ,     .
  end;
end;

function TTranslManager.IsLanguageEnabled : Boolean;
//  ,   .
begin
  Result := Self.UseTransl;
end;

function TTranslManager.GetCurrLanguage : AnsiString;
//     ,    -  none.
begin
  Result := Self.TranslUseLang;
end;

/////////////////////////////////////////////
//                        //
/////////////////////////////////////////////

function _(AOrig: String) : String;
//-  TranslMan.Transl._(AOrig);   .
begin
  Result := TranslMan.Transl._(AOrig);
end;

/////////////////////////////////
initialization

// %).  ,    ...     %)
begin
  TranslMan := TTranslManager.Create;
end;

finalization
//  ...
begin
  TranslMan.Free;
end;

end.

