///////////////////////////////////////////////////////////
//                    ao_craft_calc                      //
//          Калькулятор крафта для Аллодов Онлайн        //
//               Copyright (C) 2014 Sagrer               //
//             Распространяется на условиях              //
//                  Modified LGPL v2.1                   //
//           см. файл COPYING.modifiedLGPL.txt           //
//                                                       //
//    http://personal.sagrer.ru/tracs/ao_craft_calc      //
///////////////////////////////////////////////////////////

//Please, use UTF8-encoding to read this file.
//Chtobi prochitat etot fail - vospolzuites kodirovkoy UTF8.

//Над данным файлом работали:
// 1) Sagrer (sagrer@yandex.ru)
// 2)

////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////
//               Главная форма\окно                 //
//////////////////////////////////////////////////////

unit MainForm;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, Menus,
  ComCtrls, StdCtrls, ActnList, ValEdit, Grids, AOC_LogicClass;

const
  MFResTable_SortMin2Max = 0;   //Сортировка таблицы результатов от минимального к максимальному
  MFResTable_SortMax2Min = 1;   //Сортировка наоборот.

type

  { TMainF }

  TMainF = class(TForm)
    AlreadyDoneEd: TEdit;
    AlreadyDoneLab: TLabel;
    CalcBut: TButton;
    DelimMenu2: TMenuItem;
    ManualMenu: TMenuItem;
    ShowBadResultsChB: TCheckBox;
    RecipeLab: TLabel;
    RecipeCB: TComboBox;
    ServerTypeCB: TComboBox;
    FileMenu: TMenuItem;
    ServerTypeLab: TLabel;
    MainF_Menu: TMainMenu;
    HelpMenu: TMenuItem;
    AboutMenu: TMenuItem;
    ExitMenu: TMenuItem;
    DelimMenu1: TMenuItem;
    DebugMenu: TMenuItem;
    MainFPager: TPageControl;
    CraftCalcSheet: TTabSheet;
    RegsVLEditor: TValueListEditor;
    ResultsGrid: TStringGrid;
    procedure AboutMenuClick(Sender: TObject);
    procedure CalcButClick(Sender: TObject);
    procedure DebugMenuClick(Sender: TObject);
    procedure ExitMenuClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ManualMenuClick(Sender: TObject);
    procedure RecipeCBChange(Sender: TObject);
    procedure ResultsGridHeaderClick(Sender: TObject; IsColumn: Boolean;
      Index: Integer);
    procedure ServerTypeCBChange(Sender: TObject);
    procedure ShowBadResultsChBClick(Sender: TObject);
  private
    { private declarations }
    FirstShowed : boolean;       //Индикатор - было ли уже OnShow?
    ResultsShowed : boolean;     //Отображены ли какие-либо результаты в таблице?
    ResultsTblStringsNum : LongInt;        //Количество результатов в таблице.
    ResultsSortColumn : LongInt; //Номер колонки, по которой сортируется таблица.
    ResultsSortOrder : byte;     //Если 0 - сортировка результатов от мЕньшего к бОльшему, если 1 - от бОльшего к мЕньшему.
  public
    { public declarations }
    //Вложенные объекты.
    AppLogic : TAOC_LogicClass;     //Ссылка на класс логики приложения. Создаётся и удаляется здесь.
    //Добавленные руками методы.
    procedure LoadServRecipes(const ServerType : AnsiString);   //Загрузить в интерфейс рецепты для указанного типа сервера.
    procedure LoadCalcData();   //Метод загружает в интерфейс данные из конфига.
    procedure LoadRecipeReagents(const RecipeName : AnsiString);   //Собсно втянуть в интерфейс типы реагентов, приписанные к этому рецепту.
    procedure UpdateResTableHeader();      //Обновить текст ячеек заголовка таблицы в зависимости от текущей её сортировки.
    procedure ClearResultsTable();         //Очищалка таблицы результатов.
    procedure FillResultsTable();          //Заполнить таблицу результатов данными из класса-калькулятора.
  end;

var
  MainF: TMainF;

implementation

uses AboutForm, UTF8Process, AOC_CraftCalcEngine;

{$R *.lfm}

{ TMainF }

procedure TMainF.FormCreate(Sender: TObject);
begin
  //Изначальные значения переменных
  FirstShowed := false;     //При создании окна - отметить что оно ещё не отображалось.
  ResultsSortColumn := 0;        //Изначально сортировка всегда по первой колонке (начиная с нуля ясен пень!)
  ResultsSortOrder := MFResTable_SortMin2Max;   //по возрастанию.
  //Создать вложенные в класс объекты.
  AppLogic := TAOC_LogicClass.Create;
  //Тактически грамотно (инициализировать переменные) почистить таблицу результатов.
  Self.ClearResultsTable();
end;

procedure TMainF.ExitMenuClick(Sender: TObject);
begin
  //Просто закроем главное окно.
  Self.Close;
end;

procedure TMainF.DebugMenuClick(Sender: TObject);
begin
  //Тестовый пункт меню.

  //Тестируем сортировку реагентов.
  //Self.AppLogic.AppSettings.Recipes[0].ReSortRegs();

  //Тест обновлялки заголовка таблицы.
  //Self.UpdateResTableHeader();
end;

procedure TMainF.CalcButClick(Sender: TObject);
var
  RecipesLength, RegsLength, I, J : LongInt;
  CurrRecName, CurrServType : AnsiString;
begin
  //Нажата кнопка подсчёта количества реагентов.
  //Запиливаем инфу в объект-калькулятор.
  Self.AppLogic.CraftCalcEngine.Clear();
  //Ищем нужный рецепт.
  RecipesLength := Length(Self.AppLogic.AppSettings.Recipes);
  CurrRecName := Self.RecipeCB.Items.ValueFromIndex[Self.RecipeCB.ItemIndex];
  CurrServType := Self.ServerTypeCB.Items.ValueFromIndex[Self.ServerTypeCB.ItemIndex];
  for I := 0 to RecipesLength-1 do begin
    if (Self.AppLogic.AppSettings.Recipes[I].Name = CurrRecName) and (Self.AppLogic.AppSettings.Recipes[I].ServerType = CurrServType) then begin
      //Есть совпадение. Фигачим инфу этого рецепта в объект калькулятора.
      //Сам объект рецепта.
      Self.AppLogic.CraftCalcEngine.ActiveRecipe := Self.AppLogic.AppSettings.Recipes[I];
      //Максимальное количество разных реагентов...
      RegsLength := Length(Self.AppLogic.CraftCalcEngine.ActiveRecipe.Regs);
      SetLength(Self.AppLogic.CraftCalcEngine.MaxRegsCount,RegsLength);
      if RegsLength > 0 then begin
        for J := 0 to RegsLength-1 do begin
          Self.AppLogic.CraftCalcEngine.MaxRegsCount[J] := StrToInt(Self.RegsVLEditor.Strings.ValueFromIndex[J]);
        end;
      end;
      //На сколько процентов уже прокрафчено.
      Self.AppLogic.CraftCalcEngine.AlreadyDone := StrToFloat(Self.AlreadyDoneEd.Text);
      //Готово, вываливаемся из цикла.
      Break;
    end;
  end;

  //Вызываем собсно калькуляцию.
  Self.AppLogic.CraftCalcEngine.MakeTheCalculation();

  //Теперь надо заполнить таблицу результатами.
  Self.FillResultsTable();

  //Проставляем нужные значения в инфу формы.
  Self.ResultsShowed := true;
  Self.ResultsSortColumn := 0;   //После завершения калькуляции вывод всегда отсортирован по первой колонке...
  Self.ResultsSortOrder := MFResTable_SortMin2Max;  //... по возрастанию.
  //И обновим заголовок таблицы чтобы отобразить текущую сортировку.
  Self.UpdateResTableHeader();
end;

procedure TMainF.AboutMenuClick(Sender: TObject);
begin
  //Пользователь тыркнул по меню "о программе". Показать ему окошко.
  AboutF := TAboutF.Create(Application);
  AboutF.ShowModal;
  AboutF.Free;            //Не забыть окошко убить.
end;

procedure TMainF.FormShow(Sender: TObject);
begin
  //Действия при первой прорисовке...
  If FirstShowed = false then begin
    FirstShowed := true;

    //Запускаем инициализацию.
    if AppLogic.InitApp = false then Self.Close;     //Если вдруг были ошибки при инициализации - аварийно завершить работу.

    //Если у нас релиз или релиз-кандидат - спрятать отладочную кнопку и вкладку отладки.
    //if (AppLogic.AppVersion.Status = VIT_Status_ReleaseCandidate) or
    //   (AppLogic.AppVersion.Status = VIT_Status_Release) then
    //begin
    //  //Прячем меню.
    //  Self.DebugMenu.Visible := false;
    //  Self.DebugPage.TabVisible := false;
    //end;

    //Если мы добрались сюда значит у нас всё нормально прочиталось так что можно
    //втягивать инфу в интерфейс.
    Self.LoadCalcData();
    //Считаем что прокрафчено 0%, закидываем эту цифру в поле ввода.
    Self.AlreadyDoneEd.Text := FloatToStr(0);
  end;
end;

procedure TMainF.ManualMenuClick(Sender: TObject);
var
  NotepadProcess: TProcessUTF8;
begin
  //Пользователь тыкнул по кнопке просмотра мануала.
  NotepadProcess := TProcessUTF8.Create(nil);
  try
    NotepadProcess.CommandLine:='notepad.exe '+MainF.AppLogic.AppPath+'readme.txt';
    NotepadProcess.Execute;
  finally
    NotepadProcess.Free;
  end;
end;

procedure TMainF.RecipeCBChange(Sender: TObject);
begin
  //Выбран рецепт - подгрузим нужные реагенты.
  if Self.RecipeCB.ItemIndex >= 0 then begin
    Self.LoadRecipeReagents(Self.RecipeCB.Items.ValueFromIndex[Self.RecipeCB.ItemIndex]);
  end;
end;

procedure TMainF.ResultsGridHeaderClick(Sender: TObject; IsColumn: Boolean;
  Index: Integer);
var
  FieldCode, SortType : Byte;
  RegNum : LongInt;
begin
  //Юзверь жамкнул по заголовку таблицы результатов. Если в таблице
  //чего-нибудь есть - надо её пересортировать по жмакнутой колонке.
  if (Self.ResultsShowed = true) and (Self.ResultsTblStringsNum > 1) then begin

    //Окай, сортируем. По номеру колонки определимся с полем и если надо номером реагента.
    RegNum := 0;
    case Index of
      0 : FieldCode := AOC_CCE_SortBy_ItemsNum;
      1 : FieldCode := AOC_CCE_SortBy_CraftCost;
      2 : FieldCode := AOC_CCE_SortBy_LostPower;
      else begin
        if Index < 0 then raise Exception.Create('TMainF.ResultsGridHeaderClick - incorrect index (<0)');
        FieldCode := AOC_CCE_SortBy_RegsCount;
        //Если сортировать нужно по количеству реагентов - определим номер реагента.
        RegNum := Index-3;
      end;
    end;

    //Определимся с типом сортировки.
    if Self.ResultsSortColumn <> Index then begin
      //Выбрана другая колонка - сортируем по возрастанию.
      SortType := AOC_CCE_SortMin2Max;
    end
    else begin
      //Жамкнута уже сортируемая колонка - обратим сортировку.
      if ResultsSortOrder = AOC_CCE_SortMin2Max then begin
        SortType := AOC_CCE_SortMax2Min;
      end
      else begin
        SortType := AOC_CCE_SortMin2Max;
      end;
    end;

    //Запустим сортировку.
    Self.AppLogic.CraftCalcEngine.SortResults(SortType,FieldCode,RegNum);
    //Заново выведем таблицу.
    Self.FillResultsTable();
    //Проставляем нужные значения в инфу формы.
    Self.ResultsShowed := true;
    Self.ResultsSortColumn := Index;
    Self.ResultsSortOrder := SortType;
    //И обновим заголовок таблицы чтобы отобразить текущую сортировку.
    Self.UpdateResTableHeader();
  end;
end;

procedure TMainF.ServerTypeCBChange(Sender: TObject);
begin
  //Выбран тип сервера - подгрузим нужные рецепты.
  if Self.ServerTypeCB.ItemIndex >= 0 then begin
    Self.LoadServRecipes(Self.ServerTypeCB.Items.ValueFromIndex[Self.ServerTypeCB.ItemIndex]);
  end;
end;

procedure TMainF.ShowBadResultsChBClick(Sender: TObject);
begin
  //Юзверь жамкнул чекбокс показа неоптимальных результатов. Просто выведем таблицу
  //результатов заново.
  Self.FillResultsTable();
  //Не забыть обновить заголовки чтобы была видна текущая сортировка.
  Self.UpdateResTableHeader();
end;

procedure TMainF.LoadServRecipes(const ServerType : AnsiString);
//Загрузить в интерфейс рецепты для указанного типа сервера.
var
  I, RecipesLength : LongInt;
begin
  //Почистим список рецептов в интерфейсе.
  Self.RecipeCB.Clear;
  //Пробежимся по списку рецептов и втянем подходящие.
  RecipesLength := Length(Self.AppLogic.AppSettings.Recipes);
  if RecipesLength > 0 then begin
    for I := 0 to RecipesLength-1 do begin
      //Смотрим совпадает ли тип сервера в рецепте.
      if Self.AppLogic.AppSettings.Recipes[I].ServerType = ServerType then begin
        //Есть совпадение, втягиваем.
        Self.RecipeCB.AddItem(Self.AppLogic.AppSettings.Recipes[I].Name,nil);
      end;
    end;
  end;

  //Если есть хотя бы один рецепт - выбираем его.
  if Self.RecipeCB.Items.Count > 0 then begin
    Self.RecipeCB.ItemIndex := 0;
    Self.LoadRecipeReagents(Self.RecipeCB.Items.ValueFromIndex[Self.RecipeCB.ItemIndex]);
  end;
end;

procedure TMainF.LoadCalcData();
//Метод загружает в интерфейс данные из конфига.
var
  I, RecipesLength, TempInt : LongInt;
begin
  //Грузим типы серверов.
  Self.ServerTypeCB.Items.Clear;
  RecipesLength := Length(Self.AppLogic.AppSettings.Recipes);
  if RecipesLength > 0 then begin
    for I := 0 to RecipesLength-1 do begin
      //Смотрим загружен ли уже этот тип сервера.
      TempInt := Self.ServerTypeCB.Items.IndexOf(Self.AppLogic.AppSettings.Recipes[I].ServerType);
      if TempInt < 0 then begin
        //Сервер ещё не загружался - добавим его в список.
        Self.ServerTypeCB.AddItem(Self.AppLogic.AppSettings.Recipes[I].ServerType,nil)
      end;
    end;
  end;

  //Если есть хотя бы один тип сервера - выберем первый.
  if Self.ServerTypeCB.Items.Count > 0 then begin
    Self.ServerTypeCB.ItemIndex := 0;
    //И подгрузим нужные рецепты.
    Self.LoadServRecipes(Self.ServerTypeCB.Items.ValueFromIndex[Self.ServerTypeCB.ItemIndex]);
  end;
end;

procedure TMainF.LoadRecipeReagents(const RecipeName : AnsiString);
//Собсно втянуть в интерфейс типы реагентов, приписанные к этому рецепту.
var
  I, J, RecipesLength, RegsLength : LongInt;
begin
  //Чистим табличку с реагентами...
  Self.RegsVLEditor.Clear;
  //Ищем нужный рецепт.
  RecipesLength := Length(Self.AppLogic.AppSettings.Recipes);
  for I := 0 to RecipesLength-1 do begin
    if Self.AppLogic.AppSettings.Recipes[I].Name = RecipeName then begin
      //Есть совпадение. Ломимся по списку возможных для рецепта реагентов.
      RegsLength := Length(Self.AppLogic.AppSettings.Recipes[I].Regs);
      if RegsLength > 0 then begin
        for J := 0 to RegsLength-1 do begin
          //Просто втягиваем реагент в таблицу.
          Self.RegsVLEditor.InsertRow(Self.AppLogic.AppSettings.Recipes[I].Regs[J].RegName,'0',true);
        end;
      end;
      //Из цикла надо выйти ибо больше рецепта с тем же именем быть и не должно.
      break;
    end;
  end;

  //Почистим табличку результатов чтоб не отвлекала старой инфой если она там осталась.
  Self.ClearResultsTable();
end;

procedure TMainF.UpdateResTableHeader();
//Обновить текст ячеек заголовка таблицы в зависимости от текущей её сортировки.
var
  I : Integer;
begin
  //Делать хоть что-то вообще имеет смысл только если какие-то результаты в
  //таблицу уже выводились.
  if ResultsShowed = true then begin
    //Ломимся по колонкам таблицы.
    //ShowMessage(IntToStr(Self.ResultsGrid.RowCount-1));
    for I := 0 to Self.ResultsGrid.Columns.Count-1 do begin
      if Self.ResultsSortColumn <> I then begin
        //Эта колонка для сортировки не используется - текст должен быть обычным.
        Self.ResultsGrid.Columns.Items[I].Title.Font.Bold := false;
        Self.ResultsGrid.Columns.Items[I].Title.Font.Underline := false;
      end
      else begin
        //Сортировка идёт именно по этой колонке - меняем шрифт заголовка.
        if Self.ResultsSortOrder = MFResTable_SortMin2Max then begin
          //По возрастанию - заголовок жирный.
          Self.ResultsGrid.Columns.Items[I].Title.Font.Bold := true;
          Self.ResultsGrid.Columns.Items[I].Title.Font.Underline := false;
        end
        else begin
          //По убыванию - заголовок подчёркнутый.
          Self.ResultsGrid.Columns.Items[I].Title.Font.Bold := false;
          Self.ResultsGrid.Columns.Items[I].Title.Font.Underline := true;
        end;
      end;
    end;
  end;
end;

procedure TMainF.ClearResultsTable();
//Очищалка таблицы результатов.
begin
  //Чистим саму таблицу и, как ни странно, колонки - просто так они не очищаются.
  Self.ResultsGrid.Clear;
  Self.ResultsGrid.Columns.Clear;
  //Выставляем переменные формы по умолчанию для очищенной таблицы.
  ResultsShowed := false;   //В таблицу ещё не выводились результаты.
  ResultsTblStringsNum := 0;     //В таблице 0 строк результатов.
end;

procedure TMainF.FillResultsTable();
//Заполнить таблицу результатов данными из класса-калькулятора.
var
  ResultsNum, RealResultsNum, RegsLength, I, J, K : LongInt;
  ColCount : Integer;

begin
  //Всё зависит от того показываем ли мы неоптимальные варианты.
  RealResultsNum := Length(Self.AppLogic.CraftCalcEngine.Results);
  if Self.ShowBadResultsChB.Checked = true then begin
    //Показываем всё.
    ResultsNum := RealResultsNum;
  end
  else begin
    //Показываем только оптимальное.
    ResultsNum := RealResultsNum-Self.AppLogic.CraftCalcEngine.BadResultsCount;
  end;
  if ResultsNum > 0 then begin
    //Что-то делать имеет смысл только если есть что выводить.
    //Вытянем из движка количество реагентов в активном рецепте.
    RegsLength := Length(Self.AppLogic.CraftCalcEngine.ActiveRecipe.Regs);
    //Чистим таблицу.
    Self.ClearResultsTable();
    //Забиваем количество строк и колонок.
    ColCount := 3+RegsLength;     //количество, потери, стоимость+реагенты.
    //ResultsGrid.ColCount нельзя трогать если ResultsGrid.Columns.Enabled = true
    //Self.ResultsGrid.ColCount := 3+RegsLength;  //количество, потери, стоимость+реагенты.
    for I := 0 to ColCount-1 do begin
      //В цикле добавить колонок в Columns, хз почему компонент сам это дело не отслеживает.
      Self.ResultsGrid.Columns.Add;
    end;
    Self.ResultsGrid.FixedCols := 0;
    Self.ResultsGrid.RowCount := 1+ResultsNum;  //Заголовок+результаты.
    Self.ResultsGrid.FixedRows := 1;
    //Пишем заголовок.
    Self.ResultsGrid.ColWidths[0] := 75;
    Self.ResultsGrid.ColWidths[1] := 70;
    Self.ResultsGrid.ColWidths[2] := 60;
    //Вот так работает при Columns.Enabled = true
    Self.ResultsGrid.Columns.Items[0].Title.Caption := 'Количество';
    Self.ResultsGrid.Columns.Items[1].Title.Caption := 'Стоимость';
    Self.ResultsGrid.Columns.Items[2].Title.Caption := 'Потери %';
    //Ниже закомментированное работало при Columns.Enabled = false. Чудные люди проектировали эти табличные компоненты :(.
    //Self.ResultsGrid.Rows[0].Strings[0] := 'Количество';
    //Self.ResultsGrid.Rows[0].Strings[1] := 'Стоимость';
    //Self.ResultsGrid.Rows[0].Strings[2] := 'Потери %';
    //Ниже задаются колонки под реагенты.
    if RegsLength > 0 then begin
      for I := 0 to RegsLength-1 do begin
        Self.ResultsGrid.ColWidths[I+3] := 120;
        //Аналогичная фигня с Columns.Enabled
        Self.ResultsGrid.Columns.Items[I+3].Title.Caption := Self.AppLogic.CraftCalcEngine.ActiveRecipe.Regs[I].RegName;
        //Self.ResultsGrid.Rows[0].Strings[I+3] := Self.AppLogic.CraftCalcEngine.ActiveRecipe.Regs[I].RegName;
      end;
    end;
    //Пишем результаты.
    if RealResultsNum > 0 then begin
      K := 0;   //Это счётчик для строк в таблице т.к. с I может не совпадать если показываем только оптимальные варианты.
      for I := 0 to RealResultsNum-1 do begin
        //Записываем результат в табличку либо если он точно нормальный либо если показываем всё.
        if (Self.ShowBadResultsChB.Checked = true) or (Self.AppLogic.CraftCalcEngine.Results[I].IsBadResult = false) then begin
          //Количество.
          Self.ResultsGrid.Rows[K+1].Strings[0] := IntToStr(Self.AppLogic.CraftCalcEngine.Results[I].ItemsNum);
          //Стоимость.
          Self.ResultsGrid.Rows[K+1].Strings[1] := IntToStr(Self.AppLogic.CraftCalcEngine.Results[I].CraftCost);
          //Потери.
          Self.ResultsGrid.Rows[K+1].Strings[2] := FloatToStr(Self.AppLogic.CraftCalcEngine.Results[I].LostPower);
          //Реагенты.
          if RegsLength > 0 then begin
            for J := 0 to RegsLength-1 do begin
              Self.ResultsGrid.Rows[K+1].Strings[J+3] := IntToStr(Self.AppLogic.CraftCalcEngine.Results[I].RegsCount[J]);
            end;
          end;

          //Плюсуем счётчик строк таблицы.
          K := K+1;
        end;
      end;
    end;

    //Обновим известные в данный момент параметры формы.
    ResultsShowed := true;   //В таблицу ещё не выводились результаты.
    Self.ResultsTblStringsNum := ResultsNum;
  end;
end;

end.

