///////////////////////////////////////////////////////////
//                    ao_craft_calc                      //
//          Калькулятор крафта для Аллодов Онлайн        //
//               Copyright (C) 2014 Sagrer               //
//             Распространяется на условиях              //
//                  Modified LGPL v2.1                   //
//           см. файл COPYING.modifiedLGPL.txt           //
//                                                       //
//    http://personal.sagrer.ru/tracs/ao_craft_calc      //
///////////////////////////////////////////////////////////

//Please, use UTF8-encoding to read this file.
//Chtobi prochitat etot fail - vospolzuites kodirovkoy UTF8.

//Над данным файлом работали:
// 1) Sagrer (sagrer@yandex.ru)
// 2)

////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////
//        Класс для работы с настройками приложения.         //
//          Данные хранятся на диске в ini-файлах.           //
///////////////////////////////////////////////////////////////

//Реализует формат конфига ao_craft_calc_ini только 1й версии.


unit AOC_Settings;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LCLAnIniFile, AOC_RecipesDataContainers;

const
  AOC_Settings_FormatVersion = 1;                //Номер версии формата в данном исходнике.
  AOC_Settings_FormatName = 'ao_craft_calc_ini';      //Идентификатор формата основного файла настроек.
  //Имена файлов и прочие значения по умолчанию.
    //На данный момент нету нифига, имя файла по умолчанию в общей помойке лежит ).
  //[Main]
    //Тут только имя формата и версия т.е. значений по умолчанию в принципе и нет для секции.
  //[Reagents]
    //Секция-таблица, по умолчанию в ней в любом случае пусто.
  //[Recipes]
    //Секция-таблица, по умолчанию пусто.
  //[RecipesRegs]
    //Секция-таблица, по умолчанию пусто.

type
  TAOC_Settings = class      //Класс для работы с настройками программы.
  private
    //Закрытые методы...
  protected
    //Защищенные методы...
  public
    //Простые переменные
    //[Main]
      //По сути пустая секция, нужна только для контроля формата.
    //[Reagents]
    Reagents : AReagents;   //Динамический массив с данными секции. Размером можно управлять только через методы класса.
    //[Recipes]
    Recipes : ARecipes;   //Динамический массив со списком рецептов. Размером можно управлять только через методы класса.
    //[RecipesRegs] - данные из этой секции хранятся в массиве объектов Recipes.

    //Вложенные переменные-объекты

    //Конструкторы-деструкторы...
    constructor Create; virtual;
    destructor Destroy; override;

    //Открытые методы...
    procedure SetDefaultsForReagent(const RegIndex : LongWord);   //Проставить значения по умолчанию реагенту с указанным индексом.
    procedure SetReagentsLength(const NewLength : LongWord);  //Изменить размер массива реагентов. Если операция приведёт к увеличению массива - проставит значения по умолчанию новым элементам.
    procedure SetRecipesLength(const NewLength : LongWord);  //Изменить размер массива рецептов. Если операция приведёт к увеличению массива - создаст новые объекты, если к уменьшению - предварительно удалит ненужные.
    procedure Clear;                 //Очистить содержимое класса, выставить значения по умолчанию.
    function LoadFromFile(FName : AnsiString) : boolean;      //Прочитать файл с указанным именем.
    function SaveToFile(FName : AnsiString) : boolean;        //Сохранить файл на указанное имя.
  end;


implementation

uses Forms, LCLType, ExtraFunctionsLcl;

/////////////////////////////////////////////
//              TAOC_Settings              //
/////////////////////////////////////////////

//-----------------------------------------//
//        Конструкторы-деструкторы...      //
//-----------------------------------------//

constructor TAOC_Settings.Create;
begin
  //Создать вложенные объекты классов...

  //Чтобы инициализировать переменные и проставить дефолтные значения - вызовем очистку.
  Self.Clear;

  //Просто забить инфу в переменные...

end;

destructor TAOC_Settings.Destroy;
begin
  //Выкидываем мусор
  Self.SetReagentsLength(0);
  Self.SetRecipesLength(0);

  //Выполнить унаследованный деструктор
  inherited;
end;

//------------------------------------------//
//            Закрытые методы...            //
//------------------------------------------//

//------------------------------------------//
//           Защищенные методы...           //
//------------------------------------------//

//------------------------------------------//
//            Открытые методы...            //
//------------------------------------------//

procedure TAOC_Settings.SetDefaultsForReagent(const RegIndex : LongWord);
//Проставить значения по умолчанию реагенту с указанным индексом.
begin
  //Тупо вбить значения элементам.
  Self.Reagents[RegIndex].Name := Def_ReagentName;
  Self.Reagents[RegIndex].IcoName := Def_IcoName;
end;

procedure TAOC_Settings.SetReagentsLength(const NewLength : LongWord);
//Изменить размер массива реагентов. Если операция приведёт к увеличению
//массива - проставит значения по умолчанию новым элементам.
var
  OldLength, i : LongWord;
begin
  //Запомним текущий размер.
  OldLength := Length(Self.Reagents);
  //Меняем размер массива
  SetLength(Self.Reagents,NewLength);
  //И если размер увеличился - проставляем значения по умолчанию.
  if NewLength > OldLength then begin
    for i := NewLength-1 downto OldLength do begin
      Self.SetDefaultsForReagent(i);
    end;
  end;
end;

procedure TAOC_Settings.SetRecipesLength(const NewLength : LongWord);
//Изменить размер массива рецептов. Если операция приведёт к увеличению
//массива - создаст новые объекты, если к уменьшению - предварительно
//удалит ненужные.
var
  OldLength, i : LongWord;
begin
  //Запомним текущий размер.
  OldLength := Length(Self.Recipes);
  //И если размер увеличился - создаём объекты.
  if NewLength > OldLength then begin
    //Меняем размер массива
    SetLength(Self.Recipes,NewLength);
    for i := NewLength-1 downto OldLength do begin
      Self.Recipes[i] := TRecipeInfo.Create;
    end;
  end
  else if OldLength > NewLength then begin
    //Если размер массива уменьшается - сначала надо очистить удаляемые элементы.
    for i := OldLength-1 downto NewLength do begin
      Self.Recipes[i].Free;
    end;
    //А теперь можно и уменьшить размер массива.
    SetLength(Self.Recipes,NewLength);
  end;
end;

procedure TAOC_Settings.Clear;
//Очистить содержимое класса, выставить значения по умолчанию.
begin
  //На данный момент инфа хранится так что достаточно просто обнулить массивы.
  Self.SetReagentsLength(0);
  Self.SetRecipesLength(0);
end;

function TAOC_Settings.LoadFromFile(FName : AnsiString) : boolean;
//Прочитать файл с указанным именем.
var
  IniFile : TAnIniFile;
  AllOk, Finded : Boolean;
  TempStr : AnsiString;  //Буфер для всяких временных строк.
  TempValList : AIniValueList;  //Двумерный иассив для чтения секций типа ValueList из ini-файла.
  I, J, CurrLength, ElementsNum, RecipesNum : LongWord;
  TempRecipeReg : RRecipeRegInfo;     //Сюда временно читается инфа регов рецепта
  SystemSeparator : Char;  //Временное хранилище для системного значения десятичного разделителя.
begin
  //Инициализация
  AllOk := true;
  IniFile := TAnIniFile.Create;
  SetLength(TempValList,0,0);
  //Временно жёстко поставить десятичным разделителем запятую.
  SystemSeparator := DecimalSeparator;
  DecimalSeparator := ',';

  //Откроем файл.
  if FileExists(FName) = true then begin
    AllOk := IniFile.Load(FName);
  end
  else begin
    //Нет такого файла.
    AllOk := false;
  end;

  //Если открыть файл не удалось - ругаемся.
  if AllOk = false then begin
    Application.MessageBox(PChar('Не удалось открыть файл '+FName+' с настройками программы.'),PChar(AnsiString('Ошибка')),MB_OK or MB_ICONERROR);
  end;

  //Проверяем версию и идентификатор формата.
  if AllOk = true then begin
    TempStr := IniFile.ReadString('Main','FormatName');
    if TempStr = AOC_Settings_FormatName then begin
      //Идентификатор правильный.
      TempStr := IniFile.ReadString('Main','FormatVersion');
      if StrToInt(TempStr) <= AOC_Settings_FormatVersion then begin
        //Мы знаем что это за версия.
        if StrToInt(TempStr) < AOC_Settings_FormatVersion then begin
          //Версия слишком старая. Нужно обновить.

          //Пока что это первая версия формата, более старой версии быть не может, поэтому тут пусто.
        end;
      end
      else begin
        //Версия новее чем программа, мы не знаем чего с ней делать. Ругаемся.
        AllOk := false;
        Application.MessageBox(PChar('Формат файла '+FName+' имеет неизвестную версию '+TempStr+'. Возможно, вам следует установить более новую версию данной программы.'),PChar(AnsiString('Ошибка')),MB_OK or MB_ICONERROR);
      end;
    end
    else begin
      //Что-то не то с идентификатором. Ругаемся.
      AllOk := false;
      Application.MessageBox(PChar('Не удалось открыть файл '+FName+' с настройками программы. Неизвестный формат файла.'),PChar(AnsiString('Ошибка')),MB_OK or MB_ICONERROR);
    end;
  end;

  //Если всё ок - читаем данные.
  if AllOk = true then begin
    //[Main]
      //В этой секции читать нечего.
    //[Reagents]
    IniFile.ReadIniValueList('Reagents',TempValList);  //Читаем секцию
    CurrLength := Length(TempValList);
    //Если что-то прочиталось - парсим прочитанное. Ошибки в ini-файле понять не пытаемся, если что не так сразу остановка и всё плохо, все умерли.
    if CurrLength > 0 then begin
      //Выделяем память под нужное количество элементов.
      Self.SetReagentsLength(CurrLength);
      //Циклами проходим по вынутой инфе и закидываем прочитанное в массив.
      for I := 0 to CurrLength-1 do begin
        if AllOk = false then break;   //Чтобы цикл не продолжался если где то возникла ошибка.
        ElementsNum := Length(TempValList[I]);
        if ElementsNum > 0 then begin
          //Читаем элементы.
          for J := 0 to ElementsNum-1 do begin
            if TempValList[I,J].Name = 'Name' then begin
              Self.Reagents[I].Name := TempValList[I,J].Value;
            end
            else if TempValList[I,J].Name = 'IcoName' then begin
              Self.Reagents[I].IcoName := TempValList[I,J].Value;
            end
            else begin
              //Какой-то непонятный элемент.
              Application.MessageBox(PChar('Неизвестный элемент '+TempValList[I,J].Name+' в структуре файла '+FName+' в секции [Reagents], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
              AllOk := false;
            end;
          end;
        end
        else begin
          //В строке не может быть 0 элементов.
          Application.MessageBox(PChar('Ошибка в структуре файла '+FName+' в секции [Reagents], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
          AllOk := false;
        end;
      end;
    end;
  end;

  //Если всё ок - читаем данные.
  if AllOk = true then begin
    //[Recipes]
    SetLength(TempValList,0,0);
    IniFile.ReadIniValueList('Recipes',TempValList);  //Читаем секцию
    RecipesNum := Length(TempValList);
    //Если что-то прочиталось - парсим прочитанное. Ошибки в ini-файле понять не пытаемся, если что не так сразу остановка и всё плохо, все умерли.
    if RecipesNum > 0 then begin
      //Выделяем память под нужное количество элементов.
      Self.SetRecipesLength(RecipesNum);
      //Циклами проходим по вынутой инфе и закидываем прочитанное в массив.
      for I := 0 to RecipesNum-1 do begin
        if AllOk = false then break;   //Чтобы цикл не продолжался если где то возникла ошибка.
        CurrLength := Length(TempValList[I]);
        if CurrLength > 0 then begin
          //Читаем элементы.
          for J := 0 to CurrLength-1 do begin
            if TempValList[I,J].Name = 'Name' then begin
              Self.Recipes[I].Name := TempValList[I,J].Value;
            end
            else if TempValList[I,J].Name = 'ServerType' then begin
              Self.Recipes[I].ServerType := TempValList[I,J].Value;
            end
            else if TempValList[I,J].Name = 'TargetItem' then begin
              Self.Recipes[I].TargetItem := TempValList[I,J].Value;
            end
            else if TempValList[I,J].Name = 'UpgraderItem' then begin
              Self.Recipes[I].UpgraderItem := TempValList[I,J].Value;
            end
            else if TempValList[I,J].Name = 'UpgradeCost' then begin
              if CheckStrInt(TempValList[I,J].Value) = true then begin
                //Здесь должно быть что-то целочисленное.
                Self.Recipes[I].UpgradeCost := StrToInt(TempValList[I,J].Value);
              end
              else begin
                //Это что-то почему-то не целочисленное, ругаемся и умираем.
                Application.MessageBox(PChar('Неправильное значение (должно быть целочисленное) элемента '+TempValList[I,J].Name+' в структуре файла '+FName+' в секции [Reagents], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
                AllOk := false;
              end;
            end
            else begin
              //Какой-то непонятный элемент.
              Application.MessageBox(PChar('Неизвестный элемент '+TempValList[I,J].Name+' в структуре файла '+FName+' в секции [Reagents], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
              AllOk := false;
            end;
          end;
        end
        else begin
          //В строке не может быть 0 элементов.
          Application.MessageBox(PChar('Ошибка в структуре файла '+FName+' в секции [Reagents], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
          AllOk := false;
        end;
      end;
    end;
  end;

  //Если всё ок и есть рецепты чтобы их прочитать - читаем данные.
  if (AllOk = true) and (RecipesNum > 0) then begin
    //[RecipesRegs]
    SetLength(TempValList,0,0);
    //Эта секция читается в объекты массива Recipes поэтому механизм разбора прочитанного из ini массива немного другой :).
    IniFile.ReadIniValueList('RecipesRegs',TempValList);  //Читаем секцию
    CurrLength := Length(TempValList);
    //Если что-то прочиталось - парсим прочитанное. Ошибки в ini-файле понять не пытаемся, если что не так сразу остановка и всё плохо, все умерли.
    if CurrLength > 0 then begin
      //Циклами проходим по вынутой инфе и закидываем прочитанное в массив.
      for I := 0 to CurrLength-1 do begin
        if AllOk = false then break;   //Чтобы цикл не продолжался если где то возникла ошибка.
        ElementsNum := Length(TempValList[I]);
        if ElementsNum > 0 then begin
          //Почистим временную структуру для инфы о реагенте.
          TRecipeInfo.SetDefaultsForReg(TempRecipeReg);
          //Читаем элементы.
          for J := 0 to ElementsNum-1 do begin
            if TempValList[I,J].Name = 'RecipeName' then begin
              TempStr := TempValList[I,J].Value;
            end
            else if TempValList[I,J].Name = 'RegName' then begin
              TempRecipeReg.RegName := TempValList[I,J].Value;
            end
            else if TempValList[I,J].Name = 'CraftPrcnt' then begin
              if CheckStrFloat(TempValList[I,J].Value) = true then begin
                //Здесь должно быть что-то дробно-числовое.
                TempRecipeReg.CraftPrcnt := StrToFloat(TempValList[I,J].Value);
              end
              else begin
                //Это что-то почему-то не целочисленное, ругаемся и умираем.
                Application.MessageBox(PChar('Неправильное значение (должно быть float) элемента '+TempValList[I,J].Name+' в структуре файла '+FName+' в секции [RecipesRegs], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
                AllOk := false;
              end;
            end
            else if TempValList[I,J].Name = 'CritPrcnt' then begin
              if CheckStrFloat(TempValList[I,J].Value) = true then begin
                //Здесь должно быть что-то дробно-числовое.
                TempRecipeReg.CritPrcnt := StrToFloat(TempValList[I,J].Value);
              end
              else begin
                //Это что-то почему-то не целочисленное, ругаемся и умираем.
                Application.MessageBox(PChar('Неправильное значение (должно быть float) элемента '+TempValList[I,J].Name+' в структуре файла '+FName+' в секции [RecipesRegs], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
                AllOk := false;
              end;
            end
            else if TempValList[I,J].Name = 'UpgradeCost' then begin
              if CheckStrInt(TempValList[I,J].Value) = true then begin
                //Здесь должно быть что-то целочисленное.
                TempRecipeReg.UpgradeCost := StrToInt(TempValList[I,J].Value);
              end
              else begin
                //Это что-то почему-то не целочисленное, ругаемся и умираем.
                Application.MessageBox(PChar('Неправильное значение (должно быть целочисленное) элемента '+TempValList[I,J].Name+' в структуре файла '+FName+' в секции [RecipesRegs], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
                AllOk := false;
              end;
            end
            else begin
              //Какой-то непонятный элемент.
              Application.MessageBox(PChar('Неизвестный элемент '+TempValList[I,J].Name+' в структуре файла '+FName+' в секции [Reagents], строка секции: '+IntToStr(I)),'Ошибка',MB_OK or MB_ICONERROR);
              AllOk := false;
            end;
          end;

          //Итак, если всё ок - значит всё прочитано и надо искать рецепт с таким именем.
          if AllOk = true then begin
            J := 0;
            Finded := false;
            while (J < RecipesNum) and (Finded = false) do begin
              if Self.Recipes[J].Name = TempStr then begin
                //Нашли. Добавляем реагент рецепту.
                Finded := true;
                ElementsNum := Length(Self.Recipes[J].Regs)+1;
                Self.Recipes[J].SetRegsLength(ElementsNum);
                //Переписываем туда инфу из временной структуры.
                ElementsNum := ElementsNum-1;  //Чтобы не минусовать каждый раз при обращении к элементу.
                Self.Recipes[J].Regs[ElementsNum].RegName := TempRecipeReg.RegName;
                Self.Recipes[J].Regs[ElementsNum].CraftPrcnt := TempRecipeReg.CraftPrcnt;
                Self.Recipes[J].Regs[ElementsNum].CritPrcnt := TempRecipeReg.CritPrcnt;
                Self.Recipes[J].Regs[ElementsNum].UpgradeCost := TempRecipeReg.UpgradeCost;
              end;
              J := J+1;   //Прибавляем счётчик.
            end;
            //Если соответствующего рецепта не найдено - просто игнорируем, лишняя инфа удалится при сейве файла.
          end;

        end;
      end;
    end;

    //Надо пересортировать реагенты в рецептах.
    for I := 0 to RecipesNum-1 do begin
      Self.Recipes[I].ReSortRegs();
    end;
  end;

  //Чистим двумерный массив.
  SetLength(TempValList,0,0);

  //Походу это всё )).

  //Восстановить оригинальное значение разделителя.
  DecimalSeparator := SystemSeparator;

  //Приберём мусор и вернём результат.
  IniFile.Free;
  Result := AllOk;
end;

function TAOC_Settings.SaveToFile(FName : AnsiString) : boolean;
//Сохранить файл на указанное имя.
var
  IniFile : TAnIniFile;
  AllOk : Boolean;
  TempValList1, TempValList2 : AIniValueList;  //Двумерный иассив секций типа ValueList
  ElementsNum, I, J, RegsNum, RegsCursor : LongInt;
  SystemSeparator : Char;  //Временное хранилище для системного значения десятичного разделителя.

begin
  //Инициализация
  AllOk := true;
  IniFile := TAnIniFile.Create;
  SetLength(TempValList1,0,0);
  SetLength(TempValList2,0,0);
  RegsCursor := -1;      //Последняя позиция в массиве реагентов в которую записывалась инфа.
  //Временно жёстко поставить десятичным разделителем запятую.
  SystemSeparator := DecimalSeparator;
  DecimalSeparator := ',';


  //Формируем файл...
  IniFile.MakNewFile();
  //[Main]
  IniFile.CreateSection('Main');
  IniFile.WriteString('Main','FormatName',AOC_Settings_FormatName);
  IniFile.WriteInteger('Main','FormatVersion',AOC_Settings_FormatVersion);
  //[Reagents]
  ElementsNum := Length(Self.Reagents);
  if ElementsNum > 0 then begin
    //Секцию создаём только если есть что в неё записать.
    IniFile.CreateSection('Reagents');
    //Пилим массив.
    SetLength(TempValList1,ElementsNum);
    for I := 0 to ElementsNum - 1 do begin
      //Пишем реагенты.
      SetLength(TempValList1[I],2);      //В таблице 2 колонки.
      TempValList1[I,0].Name := 'Name';
      TempValList1[I,0].Value := Self.Reagents[I].Name;
      TempValList1[I,1].Name := 'IcoName';
      TempValList1[I,1].Value := Self.Reagents[I].IcoName;
    end;
    //Записываем таблицу в секцию.
    IniFile.WriteIniValueList('Reagents',TempValList1);
  end;

  //[Recipes] & [RecipesRegs] - пишем секции одновременно т.к. в классе они хранятся в древовидной структуре.
  SetLength(TempValList1,0,0);
  ElementsNum := Length(Self.Recipes);
  if ElementsNum > 0 then begin
    //Секцию рецептов создаём только если есть что в неё записать.
    IniFile.CreateSection('Recipes');
    //Пилим массив.
    SetLength(TempValList1,ElementsNum);
    for I := 0 to ElementsNum - 1 do begin
      //Пишем рецепты.
      SetLength(TempValList1[I],5);      //В таблице 5 колонок.
      TempValList1[I,0].Name := 'Name';
      TempValList1[I,0].Value := Self.Recipes[I].Name;
      TempValList1[I,1].Name := 'ServerType';
      TempValList1[I,1].Value := Self.Recipes[I].ServerType;
      TempValList1[I,2].Name := 'TargetItem';
      TempValList1[I,2].Value := Self.Recipes[I].TargetItem;
      TempValList1[I,3].Name := 'UpgraderItem';
      TempValList1[I,3].Value := Self.Recipes[I].UpgraderItem;
      TempValList1[I,4].Name := 'UpgradeCost';
      TempValList1[I,4].Value := IntToStr(Self.Recipes[I].UpgradeCost);
      //Теперь смотрим есть ли реагенты.
      RegsNum := Length(Self.Recipes[I].Regs);
      if RegsNum > 0 then begin
        //В рецепте есть реагенты. Увеличиваем массив.
        SetLength(TempValList2,Length(TempValList2)+RegsNum);
        //И теперь циклично фигачим туды инфу
        RegsCursor := RegsCursor+1;
        for J := RegsCursor to (RegsCursor+RegsNum)-1 do begin
          //Пишем реагент рецепта.
          SetLength(TempValList2[J],5);      //В таблице 5 колонок.
          TempValList2[J,0].Name := 'RecipeName';
          TempValList2[J,0].Value := Self.Recipes[I].Name;
          TempValList2[J,1].Name := 'RegName';
          TempValList2[J,1].Value := Self.Recipes[I].Regs[J-RegsCursor].RegName;
          TempValList2[J,2].Name := 'CraftPrcnt';
          TempValList2[J,2].Value := FloatToStr(Self.Recipes[I].Regs[J-RegsCursor].CraftPrcnt);
          TempValList2[J,3].Name := 'CritPrcnt';
          TempValList2[J,3].Value := FloatToStr(Self.Recipes[I].Regs[J-RegsCursor].CritPrcnt);
          TempValList2[J,4].Name := 'UpgradeCost';
          TempValList2[J,4].Value := IntToStr(Self.Recipes[I].Regs[J-RegsCursor].UpgradeCost);
        end;
        //Запомним позицию курсора
        RegsCursor := J;
      end;
    end;
    //Записываем таблицу [Recipes].
    IniFile.WriteIniValueList('Recipes',TempValList1);
    //И если есть что-то в массиве для [RecipesRegs] - тоже пишем.
    if Length(TempValList2) > 0 then begin
      IniFile.WriteIniValueList('RecipesRegs',TempValList2);
    end;
  end;

  //Чистим двумерные массивы.
  SetLength(TempValList1,0,0);
  SetLength(TempValList2,0,0);

  //Собсно, запись в файл на диске.
  AllOk := IniFile.Save(FName);

  //Восстановить оригинальное значение разделителя.
  DecimalSeparator := SystemSeparator;

  //Приберём мусор и вернём результат.
  IniFile.Free;
  Result := AllOk;
end;

end.

