////////////////////////////////////////////////////////////
//                ,               //
//                                    //
//                     LCL-                        //
//                        v 1.6                           //
//                                                        //
//            Copyright (C) 2007-2010 Sagrer              //
//                                                        //
//                              //
//                  Modified LGPL v2.1                    //
//           .  COPYING.modifiedLGPL.txt            //
//                                                        //
//                  sagrer@yandex.ru                      //
////////////////////////////////////////////////////////////

//      , ....  :
// 1)  (Sagrer)  (sagrer@yandex.ru)

////////////////////////////////////////////////////////////////////////

unit LCLFileInString;

{$mode objfpc}{$H+}

interface

uses
  Windows, SysUtils, Forms, Dialogs, Classes;
  
const
  //  OutputMessagesMode
  FIS_Output_none = 0;        //  .
  FIS_Output_GUI = 1;         //   GUI.
  FIS_Output_Console = 2;     //    .

type
  TFileInString = Class (TObject)                //       . +   .
  public
    //
    OutputMessagesMode : Integer;                //     -  GUI /   /  .
    FileString : AnsiString;                     //    .
    FirstLoaded : boolean;                       //   -  - .
    //-
    constructor Create; virtual;                            //c  %).
    Destructor Destroy; override;                           // .
    //
    Function Siz : Integer;                      //   .
    Function Load(const FName : AnsiString) : boolean; virtual; //  .
    Procedure Save(const FName : AnsiString);                   //  .
    Procedure MakNewFile(); virtual;                              //"  " %).
    Procedure AddChar(const ch : char);                         // .
    Procedure AddByte(const bt : byte);                         // .
    Function ReadStr(const FirstByte, BytesRead : Integer) : AnsiString;    // .
    Procedure LoadFromResource(const ResName, ResType : PChar);             //   .
  end;  

implementation

////////////////////////////////////////
//           TFileInString            //
////////////////////////////////////////

//------------------------------------//
//      -      //
//------------------------------------//

Constructor TFileInString.Create;
//  %).
begin
  FirstLoaded := false;
  FileString := '';
  SetLength(FileString,0);
  OutputMessagesMode := FIS_Output_none;      //    .
end;

Destructor TFileInString.Destroy;
begin
  // .
  SetLength(FileString,0);
  inherited;
end;

//------------------------------------//
//                              //
//------------------------------------//

Function TFileInString.Siz : Integer;
//   .
begin
  Result := Length(FileString);
end;

Function TFileInString.Load(const FName : AnsiString) : boolean;
//  .
var
  DataFile: THandle;
  FileSize: DWORD;
  Resultt : integer;
begin
  Result := false;
  FileString := '';
  Resultt := 0;
  //   .
  //     .
  //      :).
  If FileExists(FName) = true then begin
    DataFile := FileOpen(FName, fmOpenRead or fmShareDenyNone);
    if DataFile = 0 then
      if OutputMessagesMode = FIS_Output_GUI then begin
        Application.MessageBox(PChar('Error, loading'+FName),'Error',MB_OK or MB_ICONERROR);
      end
      else if OutputMessagesMode = FIS_Output_Console then begin
        Writeln('Error, loading'+FName);
      end;
    try
      FileSize := GetFileSize(DataFile, nil);
      SetLength(FileString, FileSize);
      ReadFile(THandle(DataFile),Pointer(FileString)^,FileSize,LongWord(Resultt),nil)
    finally
      CloseHandle(DataFile);
    end;
    FirstLoaded := true;
    Result := true;
  end
  else begin
    //   ( ),   !
    if OutputMessagesMode = FIS_Output_GUI then begin
      ShowMessage('!      '+FName+', ..   .  .');
    end
    else if OutputMessagesMode = FIS_Output_Console then begin
      Writeln('Error, cant load file'+FName+'because file is not exists! Check paths!');
    end;
  end;
end;

procedure TFileInString.Save(const FName : AnsiString);
//  .
var
  DataFile: THandle;
  FileSize: DWORD;
  Resultt : integer;

begin
  //   ..
  Resultt := 0;
  If Siz <> 0 then begin
    if FirstLoaded = true then begin
      //   ,  .
      if (DirectoryExists(ExtractFilePath(FName)) = false) and (ExtractFilePath(FName) <> '') then begin
        //    ,    ...
        ForceDirectories(ExtractFilePath(FName));
      end;
      //    -     .
      DataFile := CreateFile(PChar(FName),GENERIC_READ or GENERIC_WRITE,0,nil,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
      //DataFile := FileOpen(FName, fmOpenWrite or fmShareDenyWrite);
      if DataFile = 0 then
        if OutputMessagesMode = FIS_Output_GUI then begin
          Application.MessageBox(PChar('Error, Saving'+FName),'Error',MB_OK or MB_ICONERROR);
        end
        else if OutputMessagesMode = FIS_Output_Console then begin
          Writeln('Error, Saving'+FName);
        end;
      try
        FileSize := siz;
        WriteFile(THandle(DataFile),Pointer(FileString)^,FileSize,LongWord(Resultt),nil)
      finally
        CloseHandle(DataFile);
      end;
      FirstLoaded := true;
    end
    else begin
      //  ,   !
      if OutputMessagesMode = FIS_Output_GUI then begin
        ShowMessage('!...,          !     ???  ,    :(');
      end
      else if OutputMessagesMode = FIS_Output_Console then begin
        Writeln('ERROR! Nothing loaded into TFileInString class''s object! Nothing to save!');
      end;
    end;
  end
  else begin
    //   (0 )

    //try
      DataFile := CreateFile(PChar(FName),GENERIC_READ or GENERIC_WRITE,0,nil,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
    //finally
      CloseHandle(DataFile);
    //end;
  end;
end;

Procedure TFileInString.MakNewFile();
//"  " %).
begin
  //  ""  -     .
  FirstLoaded := true;
  SetLength(FileString,0);
  FileString := '';
end;

Procedure TFileInString.AddChar(const ch : char);
// .
begin
  //       .
  FileString := FileString+ch;
end;

Procedure TFileInString.AddByte(const bt : byte);
// .
begin
  //       ...
  FileString := FileString+char(bt);
end;

Function TFileInString.ReadStr(const FirstByte, BytesRead : Integer) : AnsiString;
// .
var
  TempInt, LastByte : Integer;
begin
  //     .
  //   .
  TempInt := Length(FileString);
  LastByte := FirstByte+BytesRead;

  If LastByte <= TempInt+1 then begin
    //  LastByte     .
    //(    -    ,    )
    //     :).
    SetLength(Result,LastByte-FirstByte);
    Result := Copy(FileString,FirstByte,BytesRead);
    SetLength(Result,LastByte-FirstByte);
  end
  else begin
    result := '';
  end;  
end;

Procedure TFileInString.LoadFromResource(const ResName, ResType : PChar);
//   .
var
  R : HRSRC;
  G : HGlobal;
  P : PChar;
  Sz : DWORD;
  E : Integer;
  NeedUnlock : Boolean;
  
begin
  //       ,   .
  
  // % )).       KOL.
  R := FindResource( HInstance, ResName, ResType );
  if R <> 0 then
  begin
    Sz := SizeofResource( HInstance, R );
    G := LoadResource( HInstance, R );
    if G <> 0 then
    begin
      P := GlobalLock( G );
      NeedUnlock := true;
      if P = nil then
      begin
        E := GetLastError;
        if E = ERROR_INVALID_HANDLE then begin
           //P := Pointer( G );
           P := LockResource( G );    //MSDN   LockResource        HGlobal.
           NeedUnlock := false;
        end
        else
           Exit;
      end;
      SetLength(FileString,Sz);
      CopyMemory(@FileString[1],P,Sz);
      if NeedUnlock = true then GlobalUnlock( G );
      //FreeResource( G );
      { from Win32.hlp: "You do not need to call the FreeResource
        function to free a resource loaded by using the LoadResource
        function." }
    end;
  end;
end;

end.
